/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.net.URL;
import java.util.List;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.test.kernel.junit.MicrocontainerTest;

/**
 * Unit tests for {@link EsbDeployer}.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class EsbDeployerUnitTest extends MicrocontainerTest
{
    private URL dir = getClass().getResource("/org/jboss/soa/esb/listeners/deployers/mc/test_esb_archives");
    
    private EsbDeployer esbDeployer = new EsbDeployer();
    
    public EsbDeployerUnitTest(String name)
    {
        super(name);
    }
    
    public void testExplodedEsbArchive() throws Throwable
    {
        final String archiveName = "exploded-esb-archive.esb";
        EsbMetaData esbMetaData = TestUtil.getEsbMetaData(new EsbConfigParser(), dir, archiveName);
        VFSDeploymentUnit deploymentUnit = TestUtil.getDeploymentUnit(dir, archiveName);
        
        esbDeployer.setWarFilesDir(System.getProperty("java.io.tmpdir"));
        esbDeployer.deploy(deploymentUnit, esbMetaData);
        Object attachment = deploymentUnit.getAttachment(BeanMetaData.class.getName() + "_ESB");
        assertTrue(attachment instanceof BeanMetaData);
        
        EsbDeployer esbDeployer = (EsbDeployer) getBean("EsbDeployer");
        List<String> defaultDependencies = esbDeployer.getDefaultDependencies();
        assertEquals(2, defaultDependencies.size());
        assertEquals("jboss.esb", esbDeployer.getEsbBeanPrefix());
    }
    
}
