/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.listeners.config.model;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.InputStream;
import java.io.StringReader;

import org.jboss.deployment.DeploymentException;
import org.jboss.internal.soa.esb.util.JBossDeployerUtil;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.Test;

/**
 * Unit test for validation of ESB schemas.
 * 
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 *
 */
public class ModelParserUnitTest
{
    @Test
    public void valid101XML()
        throws Exception
    {
        final boolean result = executeTest("jboss-esb-101-valid.xml") ;
        assertTrue("Valid 101 result", result) ;
    }
    
    @Test
    public void invalid101XML()
        throws Exception
    {
        final boolean result = executeTest("jboss-esb-101-invalid.xml") ;
        assertFalse("Invalid 101 result", result) ;
    }
    
    @Test
    public void invalid101XMLDisableValidation()
        throws Exception
    {
        final String current = Configuration.getDeploymentSchemaValidation() ;
        System.setProperty(Environment.DEPLOYMENT_SCHEMA_VALIDATION, "false") ;
        try
        {
            final boolean result = executeTest("jboss-esb-101-invalid.xml") ;
            assertTrue("Invalid 101 result, disabled validation", result) ;
        }
        finally
        {
            System.setProperty(Environment.DEPLOYMENT_SCHEMA_VALIDATION, current) ;
        }
    }
    
    @Test
    public void valid110XML()
        throws Exception
    {
        final boolean result = executeTest("jboss-esb-110-valid.xml") ;
        assertTrue("Valid 110 result", result) ;
    }
    
    @Test
    public void invalid110XML()
        throws Exception
    {
        final boolean result = executeTest("jboss-esb-110-invalid.xml") ;
        assertFalse("Invalid 110 result", result) ;
    }
    
    @Test
    public void invalid110XMLDisableValidation()
        throws Exception
    {
        final String current = Configuration.getDeploymentSchemaValidation() ;
        System.setProperty(Environment.DEPLOYMENT_SCHEMA_VALIDATION, "false") ;
        try
        {
            final boolean result = executeTest("jboss-esb-110-invalid.xml") ;
            assertTrue("Invalid 110 result, disabled validation", result) ;
        }
        finally
        {
            System.setProperty(Environment.DEPLOYMENT_SCHEMA_VALIDATION, current) ;
        }
    }
    
    @Test
    public void valid120XML()
        throws Exception
    {
        final boolean result = executeTest("jboss-esb-120-valid.xml") ;
        assertTrue("Valid 120 result", result) ;
    }
    
    @Test
    public void invalid120XML()
        throws Exception
    {
        final boolean result = executeTest("jboss-esb-120-invalid.xml") ;
        assertFalse("Invalid 120 result", result) ;
    }
    
    @Test
    public void invalid120XMLDisableValidation()
        throws Exception
    {
        final String current = Configuration.getDeploymentSchemaValidation() ;
        System.setProperty(Environment.DEPLOYMENT_SCHEMA_VALIDATION, "false") ;
        try
        {
            final boolean result = executeTest("jboss-esb-120-invalid.xml") ;
            assertTrue("Invalid 120 result, disabled validation", result) ;
        }
        finally
        {
            System.setProperty(Environment.DEPLOYMENT_SCHEMA_VALIDATION, current) ;
        }
    }
    
    @Test
    public void valid130XML()
        throws Exception
    {
        final boolean result = executeTest("jboss-esb-130-valid.xml") ;
        assertTrue("Valid 130 result", result) ;
    }
    
    @Test
    public void invalid130XML()
        throws Exception
    {
        final boolean result = executeTest("jboss-esb-130-invalid.xml") ;
        assertFalse("Invalid 130 result", result) ;
    }
    
    @Test
    public void invalid130XMLDisableValidation()
        throws Exception
    {
        final String current = Configuration.getDeploymentSchemaValidation() ;
        System.setProperty(Environment.DEPLOYMENT_SCHEMA_VALIDATION, "false") ;
        try
        {
            final boolean result = executeTest("jboss-esb-130-invalid.xml") ;
            assertTrue("Invalid 130 result, disabled validation", result) ;
        }
        finally
        {
            System.setProperty(Environment.DEPLOYMENT_SCHEMA_VALIDATION, current) ;
        }
    }
    
    private boolean executeTest(final String resource)
        throws DeploymentException
    {
        final ModelParser parser = new ModelParser() ;
        final InputStream resourceIS = ClassUtil.getResourceAsStream(resource, getClass()) ;
        
        assertNotNull("Null resource stream for " + resource, resourceIS) ;
        
        final String contents = JBossDeployerUtil.readEsbConfig(resourceIS) ;
        
        return parser.validate(new StringReader(contents)) ;
    }
}
