/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.schedule.MockScheduledEventMessageComposer;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.jboss.soa.esb.testutils.ESBConfigUtil;
import org.junit.Test;
import org.xml.sax.SAXException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 * @author <a href="mailto:daniel.bevenius@gmail.com">daniel.bevenius@gmail.com</a>
 */
public class ScheduledListenerUnitTest {
	
	@Test
    public void test() throws IOException, SAXException, ConfigurationException, ParserConfigurationException {
	    ESBConfigUtil configUtil = new ESBConfigUtil(ScheduledListenerUnitTest.class.getResourceAsStream("scheduled-listener-config.xml"));
        String actualListenerConfig = configUtil.getListenerConfig("simple-schedule-listener").toXml();
        String expectedListenerConfig = StreamUtils.readStreamString(getClass().getResourceAsStream("scheduled-listener-config-configtree.xml"), "UTF-8");

        assertTrue("Service configuration", XMLHelper.compareXMLContent(expectedListenerConfig, actualListenerConfig));
    }
    
    @Test
    public void onSchedule() throws SAXException, ConfigurationException, SchedulingException 
    {
    	final String composerClass = "org.jboss.soa.esb.listeners.ScheduledListenerUnitTest$MockMessageComposer";
    	final String listenerClass = "org.jboss.soa.esb.listeners.ScheduleListener";
    	final ConfigTree config = createConfigTree( composerClass, listenerClass );
    	
    	final ScheduleListener listener = new ScheduleListener( config );
    	listener.onSchedule();
    	assertEquals( "No message should have been composed", 0, MockMessageComposer.composedMessages.size() );
    	assertEquals( "ActionPipeline should not have been processed", 0, MockMessageComposer.completedMessage.size() );
    	MockMessageComposer.reset();
    }
    
    private ConfigTree createConfigTree( final String composerClass, final String listenerClass )
    {
    	final ConfigTree tree = new ConfigTree("simple-schedule-listener"); 
    	tree.setAttribute("event-processor",  composerClass );
    	tree.setAttribute("listenerClass", listenerClass );
    	tree.setAttribute("my-prop", "1");
    	tree.setAttribute("scheduleidref", "1-sec-trigger");
    	tree.setAttribute("scheduleSimpleFrequency", "1000") ;
    
    	final ConfigTree action = new ConfigTree("action", tree);
    	action.setAttribute("action", "action");
    	action.setAttribute("class", "org.jboss.soa.esb.mock.MockAction");
    	return tree;
    }
    
	/*
	 * Composer that returns null from the composeMessage() method.
	 * This should cause the ScheduleListener instance to not invoke
	 * the action processing pipeline 
	 *
	 */
	public static class MockMessageComposer extends MockScheduledEventMessageComposer {
	    public Message composeMessage() throws SchedulingException {
	    	return null;
	    }
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(ScheduledListenerUnitTest.class);
	}
}
