/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.configure;

import org.jboss.soa.esb.configure.ConfigProperty.Use;

/**
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ComponentWithNoLifecycle {

	@ConfigProperty
	private int intVal1;
	
	@ConfigProperty(defaultVal = "2")
	private int intVal2;
	
	@ConfigProperty(use = Use.OPTIONAL)
	private Integer intVal3;
	
	@ConfigProperty(choice = {"1", "2"})
	private String enumVal1;

	// Config'd by setter...
	private AlphaChar enumVal2;

	/**
	 * @return the intVal1
	 */
	public int getIntVal1() {
		return intVal1;
	}

	/**
	 * @return the intVal2
	 */
	public int getIntVal2() {
		return intVal2;
	}

	/**
	 * @return the intVal3
	 */
	public Integer getIntVal3() {
		return intVal3;
	}

	/**
	 * @return the enumVal2
	 */
	public String getEnumVal1() {
		return enumVal1;
	}

	/**
	 * @return the enumVal2
	 */
	public AlphaChar getEnumVal2() {
		return enumVal2;
	}

	/**
	 * @param enumVal2 the enumVal2 to set
	 */
	@ConfigProperty
	public void setEnumVal2(AlphaChar enumVal2) {
		this.enumVal2 = enumVal2;
	}
}
