/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.client;

import java.util.List;

import org.jboss.soa.esb.actions.Aggregator;
import org.jboss.soa.esb.message.ByReferenceMessage;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

import junit.framework.TestCase;

/**
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
 */
public class MessageMulticasterUnitTest extends TestCase {

	public void test_on_properties() {
		MessageMulticaster multicaster = new MessageMulticaster();
		Message message = MessageFactory.getInstance().getMessage();
		
		multicaster.setAggregatorOnProperties(true);
		
		assertTrue(Aggregator.getAggregatorTags(message, true) == null);		
		multicaster.addAggregationDetails(message, "uuid", 3, 123123123123L, 1);
		assertTrue(Aggregator.getAggregatorTags(message, true) != null);		
	}

	public void test_on_context() {
		MessageMulticaster multicaster = new MessageMulticaster();
		Message message = MessageFactory.getInstance().getMessage();
		
		assertTrue(Aggregator.getAggregatorTags(message, false) == null);		
		multicaster.addAggregationDetails(message, "uuid", 3, 123123123123L, 1);
		assertTrue(Aggregator.getAggregatorTags(message, false) != null);		
	}

	public void test_on_duplicated_context() {
		MessageMulticaster multicaster = new MessageMulticaster();
		Message message = MessageFactory.getInstance().getMessage();
		
		assertNull("Aggregator tags", Aggregator.getAggregatorTags(message, false));
		
		multicaster.addAggregationDetails(message, "uuid", 2, 123123123123L, 1);
		assertNotNull("First aggregator tags", Aggregator.getAggregatorTags(message, false));
		
		final Message referenceMessage = ((ByReferenceMessage)message).reference() ;
		
		multicaster.addAggregationDetails(message, "uuid", 2, 123123123123L, 2);
		assertNotNull("Second aggregator tags", Aggregator.getAggregatorTags(message, false));
		
		final List<String> referenceAggregatorTags = Aggregator.getAggregatorTags(referenceMessage, false) ;
		final List<String> finalAggregatorTags = Aggregator.getAggregatorTags(message, false) ;
		
		assertNotSame("Final aggregator tags", finalAggregatorTags, referenceAggregatorTags) ;
		assertEquals("Final aggregator tag count", 1, finalAggregatorTags.size()) ;
		assertEquals("Reference aggregator tag count", 1, referenceAggregatorTags.size()) ;
		
		final String finalAggregatorTag = finalAggregatorTags.get(0) ;
		final String referenceAggregatorTag = referenceAggregatorTags.get(0) ;
		assertFalse("Aggregator tag equality", finalAggregatorTag.equals(referenceAggregatorTag)) ;
	}
}
