/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.addressing.util.tests;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.EmailEpr;
import org.jboss.soa.esb.addressing.util.EPRManager;

/**
 * Unit tests for the Class class.
 * 
 * @author Mark Little
 */

public class EPRManagerUnitTest extends TestCase
{
	private Logger log = Logger.getLogger( EPRManagerUnitTest.class );
	
	public void testCreate ()
	{
		EPRManager manager1 = EPRManager.getInstance(null);
		EPRManager manager2 = EPRManager.getInstance("");
		EPRManager manager3 = EPRManager.getInstance("/tmp");
		
		assertEquals(manager1.equals(manager2), true);
		assertEquals(manager1.equals(manager3), false);
	}
	
	public void testInputOutput ()
	{
		EmailEpr email = new EmailEpr(EmailEpr.SMTP_PROTOCOL, "foobar", "25", "me", "letmein");
		
		String tmpDir = System.getProperty("java.io.tmpdir");
		EPRManager manager = EPRManager.getInstance(tmpDir);

		try
		{
			manager.saveEPR("MyEmail", email);

			EmailEpr loaded = new EmailEpr(manager.loadEPR("MyEmail"));
		
			assertEquals(loaded.getHost().equals("foobar"), true);
			assertEquals(loaded.getPassword().equals("letmein"), true);
		}
		catch (Exception ex)
		{
			log.error(ex);
			
			fail(ex.toString());
		}
		finally
		{
			try
			{
				manager.removeEPR("MyEmail");
			}
			catch (Exception ex)
			{
			}
		}
	}
	
	public void testSpecificInputOutput ()
	{
		EmailEpr email = new EmailEpr(EmailEpr.SMTP_PROTOCOL, "foobar", "25", "me", "letmein");
		
		String tmpDir = System.getProperty("java.io.tmpdir");
		EPRManager manager = EPRManager.getInstance(tmpDir);

		try
		{
			manager.saveEPR("MyEmail", email);
			
			EPR epr = manager.loadEPR("MyEmail");
			
			if (epr instanceof EmailEpr)
			{
			    
			}
			else
			    fail();
		}
		catch (Exception ex)
		{
			log.error(ex);
			
			fail(ex.toString());
		}
		finally
		{
			try
			{
				manager.removeEPR("MyEmail");
			}
			catch (Exception ex)
			{
			}
		}
	}

}
