/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.addressing.tests;

import java.net.URI;
import java.net.URISyntaxException;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.message.format.xml.CallImpl;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;

/**
 * Unit tests for the Class class.
 * 
 * @author Mark Little
 */

public class CallUnitTest extends TestCase
{
	public void testConstructor ()
	{
		Call call = new Call();
		
		try
		{
			assertEquals((call.getTo() == null), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testEPRConstructor ()
	{
		try
		{
			EPR epr = new EPR(new URI("http://localhost"));
			Call call = new Call(epr);
			
			assertEquals(call.getTo().equals(epr), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGetTo ()
	{
		Call call = new Call();
		
		try
		{
			EPR epr = new EPR(new URI("http://localhost"));
			
			call.setTo(epr);
			
			assertEquals(call.getTo().equals(epr), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGetFrom ()
	{
		Call call = new Call();
		
		try
		{
			EPR epr = new EPR(new URI("http://localhost"));
			
			call.setFrom(epr);
			
			assertEquals(call.getFrom().equals(epr), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGetReplyTo ()
	{
		Call call = new Call();
		
		try
		{
			EPR epr = new EPR(new URI("http://localhost"));
			
			call.setReplyTo(epr);
			
			assertEquals(call.getReplyTo().equals(epr), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGetFaultTo ()
	{
		Call call = new Call();
		
		try
		{
			EPR epr = new EPR(new URI("http://localhost"));
			
			call.setFaultTo(epr);
			
			assertEquals(call.getFaultTo().equals(epr), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGetRelatesTo ()
	{
		Call call = new Call();
		
		try
		{
			URI uri = new URI("urn:1234");
			
			call.setRelatesTo(uri);
			
			assertEquals(call.getRelatesTo().equals(uri), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGetAction ()
	{
		Call call = new Call();
		
		try
		{
			URI uri = new URI("urn:1234");
			
			call.setAction(uri);
			
			assertEquals(call.getAction().equals(uri), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSetGetMessageID ()
	{
		Call call = new Call();
		
		try
		{
			URI uri = new URI("urn:1234");
			
			call.setMessageID(uri);
			
			assertEquals(call.getMessageID().equals(uri), true);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSerialisation()
	    throws Exception
	{
	    final Call call = new Call() ;
	    call.setAction(new URI("urn:action")) ;
            call.setFaultTo(getEPR("urn:faultTo", "faultToTag", "faultToValue")) ;
	    call.setFrom(getEPR("urn:from", "fromTag", "fromValue")) ;
            call.setMessageID(new URI("urn:messageID")) ;
	    call.setRelatesTo(new URI("urn:relatesTo")) ;
	    call.setReplyTo(getEPR("urn:replyTo", "replyToTag", "replyToValue")) ;
            call.setTo(getEPR("urn:to", "toTag", "toValue")) ;
            
            final String content = CallImpl.toXML(call) ;
            final Call result = CallImpl.fromXML(content) ;
            
            assertEquals("Action URI", call.getAction(), result.getAction()) ;
            assertEquals("FaultTo EPR", call.getFaultTo(), result.getFaultTo()) ;
            assertEquals("From EPR", call.getFrom(), result.getFrom()) ;
            assertEquals("MessageID URI", call.getMessageID(), result.getMessageID()) ;
            assertEquals("RelatesTo URI", call.getRelatesTo(), result.getRelatesTo()) ;
            assertEquals("ReplyTo URI", call.getReplyTo(), result.getReplyTo()) ;
            assertEquals("To URI", call.getTo(), result.getTo()) ;
	}
	
	private EPR getEPR(final String uri, final String tag, final String value)
	    throws URISyntaxException
	{
            final EPR epr = new EPR(new URI(uri)) ;
            epr.getAddr().addExtension(tag, value) ;
            return epr ;
	}
}
