/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.addressing.helpers.tests;

import java.net.URI;
import java.net.URISyntaxException;

import junit.framework.TestCase;

import org.jboss.soa.esb.addressing.eprs.InVMEpr;

/**
 * Unit tests for the InVM EPR class.
 * 
 * @author Mark Little
 */

public class InVMUnitTest extends TestCase
{

	public void testConstructor ()
	{
		try
		{
			new InVMEpr(new URI("invm://myservice?true#1234"));
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
        
        public void testPassByValue()
        {
                try
                {
                        InVMEpr epr = new InVMEpr(new URI("invm://myservice/true?true#1234"));
                        
                        assertEquals(epr.getPassByValue(), true);
                }
                catch (Exception ex)
                {
                        fail(ex.toString());
                }
        }
	
	public void testSetGet ()
	{
		try
		{
			InVMEpr em = new InVMEpr(new URI("invm://myservice?true#1234"));
			
			assertEquals(em.getServiceId(), "myservice");
			assertEquals(em.getLockstep(), true);
			assertEquals(em.getLockstepWaitTime(), 1234);
			
			em = new InVMEpr(new URI("invm://myservice"));
			
			assertEquals(em.getServiceId(), "myservice");
			assertEquals(em.getLockstep(), false);
			assertEquals(em.getLockstepWaitTime(), InVMEpr.DEFAULT_LOCKSTEP_WAIT_TIME);
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}

    public void test_getEncodedServiceId() throws URISyntaxException {
        String serviceId = InVMEpr.createEncodedServiceId("Service Cat / &&&", " Service / Name $$");
        assertEquals("5365727669636520436174202f2026262624242424242424242424242453657276696365202f204e616d65202424", serviceId);

        InVMEpr epr = new InVMEpr(new URI(InVMEpr.INVM_PROTOCOL + "://" + serviceId));
        assertEquals("5365727669636520436174202f2026262624242424242424242424242453657276696365202f204e616d65202424", epr.getServiceId());
    }
}
