/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.aggregation;

import org.jboss.internal.soa.esb.couriers.MockCourier;
import org.jboss.internal.soa.esb.message.format.xml.MessageImpl;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.tests.XMLMessageUnitTest;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.addressing.MalformedEPRException;

import java.util.List;
import java.util.ArrayList;

import junit.framework.Assert;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
*/
class TestCourier extends MockCourier {

    public List<Message> messages = new ArrayList<Message>();

    public TestCourier() {
        super(true);
    }

    public boolean deliver(Message message) throws CourierException, MalformedEPRException {
        try {
            String xmlRepresentation = XMLMessageUnitTest.msgToXML((MessageImpl)message);
            messages.add(XMLMessageUnitTest.msgFromXML(xmlRepresentation));
            return true;
        } catch(Exception e) {
            e.printStackTrace();
            Assert.fail(e.getMessage());
        }
        return false;
    }
}
