/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions;

import java.util.List;

/**
 * Just a simple test JavaBean class.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 * @since Version 4.0
 */
public class TestBean implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
    public enum GENDER { MALE, FEMALE};
	private String name;
	private String initials;
    private String phone;
    private List<String> addresses;
    
    private GENDER gender;

    public TestBean() {
    }
    
    public TestBean(String name, String phone) {
        this.name = name;
        this.phone = phone;
    }
    
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public String getPhone() {
        return phone;
    }
    public void setPhone(String phone) {
        this.phone = phone;
    }
	public String getInitials()
	{
		return initials;
	}
	public void setInitials(String initials)
	{
		this.initials = initials;
	}
	
	public GENDER getGender()
	{
		return gender;
	}
	
	public void setGender(GENDER gender)
	{
		this.gender = gender;
	}

    public List<String> getAddresses()
    {
        return addresses;
    }

    public void setAddresses(List<String> addresses)
    {
        this.addresses = addresses;
    }
    
    public String toString()
    {
        return "TestBean [name=" + name + ", phone=" + phone + ", initials=" + initials + ", gender=" + gender + ", addresses=" + addresses + "]";
    }
}
