/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions;

import static org.junit.Assert.*;
import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Level;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.Test;

/**
 * Unit test for {@link LogAction}
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>			
 *
 */
public class LogActionUnitTest
{
	@Test
	public void logLevel()
	{
		LogAction logAction = new LogAction();
		assertEquals( Level.DEBUG, logAction.getLevel() );
	}
	
	@Test
	public void setLogger()
	{
		LogAction logAction = new LogAction();
		assertEquals( LogAction.class.getName(), logAction.getLogger() );
		
		logAction.setLogger( getClass().getName() );
		assertEquals( LogActionUnitTest.class.getName(), logAction.getLogger() );
	}
	
	@Test
	public void log()
	{
		LogAction logAction = new LogAction();
		logAction.setLogger( getClass().getName() );
		logAction.setLogLevel( "info" );
		logAction.log( "testing" );
	}
	
	@Test
	public void process()
	{
		LogAction logAction = new LogAction();
		logAction.setLogger( getClass().getName() );
		logAction.setLogLevel( "info" );
		logAction.setMessage( "body:" );
		logAction.setLogBody( true );
		Message message = MessageFactory.getInstance().getMessage();
		message.getBody().add( " some body..." );
		logAction.process( message );
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( LogActionUnitTest.class );
	}

}
