/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.util;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;

import junit.framework.JUnit4TestAdapter;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.ls.LSInput;

/**
 * Unit test for {@link SchemaResolver}.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class SchemaResolverUnitTest
{
    private SchemaResolver schemaResolver;
    
    @Before
    public void setup() throws URISyntaxException
    {
        URL resource = getClass().getResource("/org/jboss/internal/soa/esb/util/types/custom-type.xsd");
        schemaResolver = new SchemaResolver(resource.toURI());
    }
    
    @Test
    public void testSchemaOnClasspath()
    {
        final String type = "http://www.w3.org/2001/XMLSchema";
        final String systemId = "custom-type.xsd";
        
        LSInput lsInput = schemaResolver.resolveResource(type, "http://www.jboss.org/custom", null, systemId, null);
        Reader characterStream = lsInput.getCharacterStream();
        assertNotNull(characterStream);
    }
    
    @Test
    public void testSchemaWithHttpUrlSystemId()
    {
        final String type = "http://www.w3.org/2001/XMLSchema";
        
        final String systemId = "http://www.jboss.org/esb/custom-type.xsd";
        
        LSInput lsInput = schemaResolver.resolveResource(type, "http://www.jboss.org/custom", null, systemId, null);
        assertNull(lsInput.getCharacterStream());
        assertNotNull(lsInput.getSystemId());
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SchemaResolverUnitTest.class);
    }

}
