/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import junit.framework.TestCase;
import org.jboss.internal.soa.esb.message.format.MessageFactoryImpl;
import org.jboss.internal.soa.esb.message.format.MessageSerializer;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageType;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class XMLMessageSerializerUnitTest extends TestCase {

    public void test_all_ok() throws IOException {
        Message originalMessage = MessageFactoryImpl.getInstance().getMessage(MessageType.JBOSS_XML);
        XMLMessageSerializer serializer = new XMLMessageSerializer();

        originalMessage.getBody().add("This is an XML Message!");

        // serialize the message to bytes...
        ByteArrayOutputStream bytesOutStream = new ByteArrayOutputStream();
        serializer.serialize(originalMessage, bytesOutStream);

        // deserialize the message from bytes....
        ByteArrayInputStream bytesInStream = new ByteArrayInputStream(bytesOutStream.toByteArray());
        Message deserMessage = serializer.deserialize(bytesInStream);

        // Make sure they're the same message...
        assertEquals("This is an XML Message!", deserMessage.getBody().get());
    }

    public void test_invalid_preamble() throws IOException {
        Message originalMessage = MessageFactoryImpl.getInstance().getMessage(MessageType.JBOSS_XML);
        XMLMessageSerializer serializer = new XMLMessageSerializer();

        // serialize the message to bytes...
        ByteArrayOutputStream bytesOutStream = new ByteArrayOutputStream();
        serializer.serialize(originalMessage, bytesOutStream);

        // deserialize the message from bytes, corrupt it and then try deserialize....
        byte[] messageBytes = bytesOutStream.toByteArray();
        messageBytes[0] = MessageSerializer.PREAMBLE_JAVA;
        ByteArrayInputStream bytesInStream = new ByteArrayInputStream(messageBytes);
        try {
            serializer.deserialize(bytesInStream);
            fail("Expected IOException.");
        } catch(IOException e) {
            assertEquals("Cannot deserialize message.  Unrecognized message preamble.", e.getMessage());
        }
    }
}
