/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.dependencies;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.testutils.HsqldbUtil;
import org.jboss.soa.esb.helpers.persist.SimpleDataSource;
import junit.framework.TestCase;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.mockejb.jndi.MockContextFactory;

/**
 * DatabaseIntializer test - tests the getters/setters and tests whether
 * a database can be successfully intialized.
 * 
 * @author tcunning@redhat.com
 */
public class DatabaseInitializerUnitTest extends TestCase {
    private static final String PERSIST_DB_DIR = System.getProperty("org.jboss.esb.test.persistdb.dir",
		"./rosetta/tests/resources/etc");
    
    private static String JNDI_DATASOURCE = "JNDI.DATASOURCE";
    private static String TEST_STRING = "TEST";
    
    private static Logger logger = Logger.getLogger(DatabaseInitializerUnitTest.class);
    private static String mDbDriver ="org.hsqldb.jdbcDriver";
    private static String mDbUrl = "jdbc:hsqldb:file:" + PERSIST_DB_DIR + "/persistUnitTestDB";
    private static String mDbUsername = "sa";
    private static String mDbPassword ="";
    
    private static Object server ;
    
	protected void setUp() throws Exception {
        server = HsqldbUtil.startHsqldb(PERSIST_DB_DIR + "/persistUnitTestDB", "persistUnitTestDB");
        
        MockContextFactory.setAsInitial();
    }
    
	public void testGetters() {
		DatabaseInitializer di = new DatabaseInitializer();
		di.setDatasource(TEST_STRING);
		assertEquals(di.getDatasource(), TEST_STRING);
		
		di.setExistsSql(TEST_STRING);
		assertEquals(di.getExistsSql(), TEST_STRING);
		
		di.setSqlFiles(TEST_STRING);
		assertEquals(di.getSqlFiles(), TEST_STRING);
	}
	
    public void testInitialization() {
    	SimpleDataSource simpleDS = new SimpleDataSource(mDbDriver, mDbUrl, mDbUsername, mDbPassword);
            // Grab the connection created and do a simple Query - we expect a result
    	try {
    		Context ctx = new InitialContext();
    		ctx.rebind(JNDI_DATASOURCE, simpleDS);
		
    		DatabaseInitializer di = new DatabaseInitializer();
    		di.setDatasource(JNDI_DATASOURCE);
			di.setExistsSql("select * from AUTH_TOKEN");
			di.setSqlFiles("org/jboss/internal/soa/esb/test.sql");
			di.initDatabase();
		} catch (NamingException e) {
			e.printStackTrace();
			fail(e.getMessage());
		} catch (Exception e) {
			e.printStackTrace();
			fail(e.getMessage());		
		}
	}
    
    protected void tearDown() throws Exception {
    	   MockContextFactory.revertSetAsInitial();
    	   HsqldbUtil.stopHsqldb(server);
   	}
}
