/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.internal.soa.esb.couriers.tests;

import java.io.File;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.couriers.helpers.FileHandlerFactory;
import org.jboss.internal.soa.esb.couriers.helpers.FtpFileHandler;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.couriers.CourierException;
import org.junit.Test;

/**
 * Tests for internal FtpFileHandler class
 * 
 * @since Version 4.0
 * 
 */
public class FtpFileHandlerIntegrationTest extends BaseTest
{
	public static junit.framework.Test suite()
	{
		System.err.println("<------------------------------------------>");
		System.err.println("<- FTPFileHandlerIntegrationTest requires ->");
		System.err.println("<- an available FTP server to work.       ->");
		System.err.println("<------------------------------------------>");
		
		return new JUnit4TestAdapter(FtpFileHandlerIntegrationTest.class);
	}
	
	@Test
	public void testConstructor () throws Exception
	{
		FTPEpr ftpEpr = new FTPEpr("ftp://test:password@foo.bar");

		try
		{
			@SuppressWarnings("unused")
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
		
		ftpEpr = new FTPEpr("ftp://foo.bar");
		
		try
		{
			@SuppressWarnings("unused")
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
	}
	
	@Test
	public void testInvalidConnect () throws Exception
	{
		File theFile = new File("test.txt");
		FTPEpr ftpEpr = new FTPEpr("ftp://test:password@foo.bar");

		try
		{
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
			
			@SuppressWarnings("unused")
			byte[] content = handler.getFileContents(theFile);
		}
		catch (CourierException ex)
		{
			// good!!
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
	
		ftpEpr = new FTPEpr("ftp://" + getFtpUser() + "@" + getFtpHostname() + ":9090");
		
		try
		{
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
			
			@SuppressWarnings("unused")
			byte[] content = handler.getFileContents(theFile);
		}
		catch (CourierException ex)
		{
			// good!!
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
		
		ftpEpr = new FTPEpr("ftp://" + getFtpUser() + "@" + getFtpHostname());
		
		try
		{
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
			
			@SuppressWarnings("unused")
			byte[] content = handler.getFileContents(theFile);
		}
		catch (CourierException ex)
		{
			// good!!
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
	}
	
	@Test
	public void testValidConnect () throws Exception
	{
		FTPEpr ftpEpr = null;
		
		if (getFtpPwd() != null)
			ftpEpr = new FTPEpr("ftp://" + getFtpUser() + ":" + getFtpPwd()+ "@" + getFtpHostname() + getFtpDir());
		else
			ftpEpr = new FTPEpr("ftp://" + getFtpUser() + "@" + getFtpHostname() + getFtpDir());

		try
		{
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
			
			@SuppressWarnings("unused")
			File[] files = handler.getFileList();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
	}
	
	@Test
	public void testDeleteBadFile () throws Exception
	{
		File theFile = new File("test1234567890.txt");
		FTPEpr ftpEpr = new FTPEpr("ftp://" + getFtpUser() + "@" + getFtpHostname() + getFtpDir());

		try
		{
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
			
			handler.deleteFile(theFile);
		}
		catch (CourierException ex)
		{
			// TODO should really look for false being returned to indicate no such file!
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
	}
	
	@Test
	public void testGetFileList () throws Exception
	{
		FTPEpr ftpEpr = null;
		
		if (getFtpPwd() != null)
			ftpEpr = new FTPEpr("ftp://" + getFtpUser() + ":" + getFtpPwd()+ "@" + getFtpHostname() + getFtpDir());
		else
			ftpEpr = new FTPEpr("ftp://" + getFtpUser() + "@" + getFtpHostname() + getFtpDir());
			
		try
		{
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
			
			File[] files = handler.getFileList();
			
			System.err.print("Received information on ");
			
			if (files != null)
				System.err.println(files.length+" files");
			else
				System.err.println("zero files");
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
	}
	
	@Test
	public void testGetFile () throws Exception
	{
		FTPEpr ftpEpr = null;
		
		if (getFtpPwd() != null)
			ftpEpr = new FTPEpr("ftp://" + getFtpUser() + ":" + getFtpPwd()+ "@" + getFtpHostname() + getFtpDir());
		else
			ftpEpr = new FTPEpr("ftp://" + getFtpUser() + "@" + getFtpHostname() + getFtpDir());

		try
		{
			FtpFileHandler handler = (FtpFileHandler) FileHandlerFactory.getInstance().getFileHandler(ftpEpr);
			
			File[] files = handler.getFileList();
			
			if ((files != null) && (files.length > 0))
			{
				System.err.println("Getting file "+files[0]);
				
				/*
				 * This may return files within subdirectories. Unfortunately
				 * the FTP Courier doesn't cope with them. At least it now
				 * ignores them safely.
				 */
				
				byte[] contents = handler.getFileContents(files[0]);
				
				if (contents != null)
				{
					String theFile = new String(contents);
					
					System.err.println("Received:\n"+theFile);
				}
				else
					System.err.println("Received: no file contents. Probably a directory.");
			}
			else
				System.err.println("No files on remote server.");
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			
			Assert.fail();
		}
	}
	
}
