/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Cross Site Scripting (XSS) util class.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public final class XssUtil
{
    private static Pattern ampPattern = Pattern.compile("&");
    private static Pattern quotePattern = Pattern.compile("[\"]");
    private static Pattern openTagPattern = Pattern.compile("[<]|(%3C)");
    private static Pattern closeTagPattern = Pattern.compile("[>]|(%3E)");
    
    private XssUtil()
    {
    }

    public static String escape(final String text)
    {
        String replace = replace(ampPattern, text, "&amp;");
        replace = replace(quotePattern, replace, "&quot;");
        replace = replace(openTagPattern, replace, "&lt;");
        replace = replace(closeTagPattern, replace, "&gt;");
        return replace;
    }
    
    private static String replace(final Pattern pattern, final String text, final String replacement)
    {
        final Matcher m = pattern.matcher(text);
        if (m.find())
        {
            return m.replaceAll(replacement);
        }
        return text;
        
    }
    
}
