/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.util;

import java.io.IOException;

import javax.jms.JMSException;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.services.security.PasswordUtil;

/**
 * Utility methods for JMS operations.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class JmsUtil
{
    private static Logger log = Logger.getLogger(JmsUtil.class);
    
    private JmsUtil()
    {
    }
    
    /**
     * Will return the decrypted password from the passed in file.
     * 
     * @param password The path to the password file.
     * @return String Either the decrypted password or the passed in password unchanged.
     * 
     * @throws JMSException If an error occurs while decrypting.
     */
    public static String getPasswordFromFile(final String password) throws JMSException
    {
        if (PasswordUtil.isPasswordFile(password))
        {
            try
            {
                return new PasswordUtil(password).getPasswordAsString();
            }
            catch (final IOException e)
            {
                final String errorMsg = "Could not read password from file : " + password;
                log.error(errorMsg, e);
                throw new JMSException(errorMsg + ", " + e.getMessage());
            }
        }
        
        return password;
        
    }
    
    public static boolean isSecurityConfigured(final String principal, final String credential)
    {
        return principal != null && credential != null;
    }

}
