/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;
import static org.jboss.soa.esb.services.security.auth.ws.SoapConstants.SOAP_HEADER_QNAME;
import static org.jboss.soa.esb.services.security.auth.ws.SoapConstants.SOAP_BODY_QNAME;

import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/**
 * Util class for operations common to extractors that deal with soap xml messages.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public final class SoapExtractionUtil
{
    private SoapExtractionUtil()
    {
    }
    
    public static boolean isStartOfHeader(final XMLEvent event)
    {
        return event.isStartElement() && ((StartElement)event).getName().equals(SOAP_HEADER_QNAME);
    }
    
    public static boolean isEndOfHeader(final XMLEvent event)
    {
        return event.isEndElement() && ((EndElement)event).getName().equals(SOAP_HEADER_QNAME);
    }
    
    public static boolean isStartOfBody(final XMLEvent event)
    {
        return event.isStartElement() && ((StartElement)event).getName().equals(SOAP_BODY_QNAME);
    }
}
