/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import javax.xml.namespace.QName;

/**
 * Holds constants for SOAP related elements. 
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public final class SoapConstants
{
    /**
     * QName for SOAP Header element.
     */
    public static final QName SOAP_HEADER_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header");
    
    /**
     * QName for SOAP Body element.
     */
    public static final QName SOAP_BODY_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    
    /**
     * Local name for Security header element.
     */
    public static final String WSSE_LN = "Security";
    
    /**
     * SOAP Message Security 1.0 NameSpace URL
     */
    public static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSSE_NS2 = "http://schemas.xmlsoap.org/ws/2002/04/secext";
    
    /**
     * SOAP Message Security 1.1 NameSpace URL
     */
    public static final String WSSE11_NS = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    
    public static final QName WSSE_QNAME = new QName(WSSE_NS, WSSE_LN);
    public static final QName WSSE_2_QNAME = new QName(WSSE_NS2, WSSE_LN);
    public static final QName WSSE_11_QNAME = new QName(WSSE11_NS, WSSE_LN);
    
    private SoapConstants()
    {
    }

}
