/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.auth.TokenCallback;
import org.jboss.internal.soa.esb.services.security.EsbCallbackHandler;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

/**
 * JAAS callback handler that can be used with JBossSTS login modules.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class JBossSTSTokenCallbackHandler implements EsbCallbackHandler 
{
    private Logger log = Logger.getLogger(JBossSTSTokenCallbackHandler.class);
    
	private AuthenticationRequest authRequest;
	
	public JBossSTSTokenCallbackHandler()
	{
	}
	
	public JBossSTSTokenCallbackHandler(final AuthenticationRequest authRequest)
	{
	    this.authRequest = authRequest;
	}
	
    public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException
    {
        for (Callback callback : callbacks)
        {
            if (callback instanceof TokenCallback)
            {
                final TokenCallback tokenCallback = (TokenCallback) callback;
		        for (Object object : authRequest.getCredentials())
		        {
		            if (object instanceof SamlCredential)
		            {
                        try
                        {
                            tokenCallback.setToken(((SamlCredential)object).getAssertionAsElement());
                        }
                        catch (ProcessingException e)
                        {
                            log.error(e.getMessage(), e);
                        }
		            }
		        }
            }
        }
    }

    public void setAuthenticationRequest(AuthenticationRequest authRequest)
    {
        this.authRequest = authRequest;
    }

    public void setSecurityConfig(SecurityConfig config)
    {
    }
}
