/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.services.registry;

/**
 * An abstract registry interceptor for managing the registry assignment.
 * 
 * @author <a href='mailto:Kevin.Conner@jboss.com'>Kevin Conner</a>
 */
public abstract class AbstractRegistryInterceptor implements RegistryInterceptor
{
    /**
     * The next registry or interceptor in the chain.
     */
    private Registry registry ;
    
    /**
     * Initialise the registry or interceptor that is next in the chain.
     * @param registry The next entry in the chain or null if dismantling.
     */
    public synchronized void setRegistry(final Registry registry)
    {
        this.registry = registry ;
    }
    
    /**
     * Get the next registry or interceptor in the chain.
     * @return The next registry or interceptor in the chain.
     * @throws RegistryException If the chain has been dismantled.
     */
    protected synchronized Registry getRegistry()
        throws RegistryException
    {
        if (registry == null)
        {
           throw new RegistryException("Registry has been reconfigured and is no longer valid") ;
        }
        return registry ;
    }
}
