/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author derek.adams@sapience360.com
 */

package org.jboss.soa.esb.message.properties;

import java.util.Calendar;

import org.jboss.soa.esb.message.Message;

/**
 * Allows for manipulation of message properties using well-known names.
 * 
 * @author Derek Adams
 */
public class MessagePropertyFacade {

	/** Wrapped message instance */
	protected Message message;

	/** Constant for message id property name */
	public static final String MESSAGE_ID = "jbossesb.message.id";

	/** Constant for message category property name */
	public static final String MESSAGE_CATEGORY = "jbossesb.message.category";

	/** Constant for message category property name */
	public static final String MESSAGE_CREATED_DATE = "jbossesb.message.created.date";

	/** Constant for message delivered property name */
	public static final String MESSAGE_DELIVERED = "jbossesb.message.delivered";

	/**
	 * Create a facade that wraps the given message.
	 * 
	 * @param message
	 */
	public MessagePropertyFacade(Message message) {
		this.message = message;
	}

	/**
	 * Get the message id.
	 * 
	 * @return String
	 */
	public String getMessageId() {
		return (String) message.getProperties().getProperty(MESSAGE_ID);
	}

	/**
	 * Set the message id.
	 * 
	 * @param messageId
	 */
	public void setMessageId(String messageId) {
		message.getProperties().setProperty(MESSAGE_ID, messageId);
	}

	/**
	 * Get the message category.
	 * 
	 * @return String
	 */
	public String getMessageCategory() {
		return (String) message.getProperties().getProperty(MESSAGE_CATEGORY);
	}

	/**
	 * Set the message category.
	 * 
	 * @param category
	 */
	public void setMessageCategory(String category) {
		message.getProperties().setProperty(MESSAGE_CATEGORY, category);
	}

	/**
	 * Get the message created date.
	 * 
	 * @return Calendar
	 */
	public Calendar getCreatedDate() {
		return (Calendar) message.getProperties().getProperty(MESSAGE_CREATED_DATE);
	}

	/**
	 * Set the message created date.
	 * 
	 * @param createdDate
	 */
	public void setCreatedDate(Calendar createdDate) {
		message.getProperties().setProperty(MESSAGE_CREATED_DATE, createdDate);
	}

	/**
	 * Indicates whether the message was delivered.
	 * 
	 * @return Boolean
	 */
	public Boolean wasDelivered() {
		return (Boolean) message.getProperties().getProperty(MESSAGE_DELIVERED);
	}

	/**
	 * Set the indicator for whether the message was delivered.
	 * 
	 * @param delivered
	 */
	public void setDelivered(Boolean delivered) {
		message.getProperties().setProperty(MESSAGE_DELIVERED, delivered);
	}
}