/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2010
 */
package org.jboss.soa.esb.listeners.gateway.camel;

import java.net.URI;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * JBossESBComponent.
 * 
 * @author dward at jboss.org
 */
public class JBossESBComponent extends DefaultComponent
{
	
	public static final String JBOSSESB = "jbossesb";
	public static final String SERVICE = "service";
	public static final String CATEGORY = "category";
	public static final String NAME = "name";
	public static final String ASYNC = "async";
	public static final String TIMEOUT = "timeout";
	
	private final ConfigTree config;
	
	public JBossESBComponent(ConfigTree config) {
		this.config = config;
	}
	
	@Override
	protected Endpoint createEndpoint(String uri, String command, Map<String, Object> parameters) throws Exception
	{
		Processor processor;
		if (SERVICE.equalsIgnoreCase(command))
		{
			String category = getAndRemoveParameter(parameters, CATEGORY, String.class);
			String name = getAndRemoveParameter(parameters, NAME, String.class);
			boolean async = getAndRemoveParameter(parameters, ASYNC, Boolean.class, Boolean.FALSE);
			long timeout = getAndRemoveParameter(parameters, TIMEOUT, Long.class, 30000L);
			processor = new ServiceProcessor(config, new Service(category, name), async, timeout);
		}
		else
		{
			throw new Exception("unrecognized command: " + command + " from uri: " + uri);
		}
		Endpoint endpoint = new ProcessorEndpoint(uri, this, processor);
		setProperties(endpoint, parameters);
		return endpoint;
	}
	
	public static URI createEndpointURI(String command, Map<String,Object> parameters) throws Exception {
		StringBuilder sb = new StringBuilder();
		sb.append(JBOSSESB);
		sb.append("://");
		sb.append(command);
		if (parameters != null) {
			int i=0;
			for (Entry<String,Object> param : parameters.entrySet()) {
				Object value = param.getValue();
				if (value != null) {
					if (i == 0) {
						sb.append("?");
					} else {
						sb.append("&");
					}
					sb.append(param.getKey());
					sb.append("=");
					sb.append(value);
					i++;
				}
			}
		}
		return new URI(sb.toString());
	}
	
}
