/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.gateway;

/**
 * Bean for hibernate events - contains an event and a class name.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.2
 * 
 */
public class HibernateEventBean {
	private String m_event;
	private String m_className;
	
	public HibernateEventBean() {
	}
	
	/**
	 * Constructor
	 * @param f_event event
	 * @param f_className class name
	 */
	public HibernateEventBean(String f_event, String f_className) {
		m_event = f_event;
		m_className = f_className;
	}
	
	/**
	 * Accessor for class name.
	 * @return class name
	 */
	public String getClassname() {
		return m_className;
	}
	
	/**
	 * Mutator for class name
	 * @param classname class name
	 */
	public void setClassname(String classname) {
		m_className = classname;
	}
	
	/**
	 * Accessor for list of events.
	 * @return comma separated list of events
	 */
	public String getEvent() {
		return m_event;
	}
	
	/**
	 * Mutator for event
	 * @param m_event
	 */
	public void setEvent(String m_event) {
		this.m_event = m_event;
	}
}
