/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

/**
 * Interface for exposing JMX operations.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public interface EsbDeploymentMBean
{
    /**
     * Start a deployment.
     * 
     * @throws Exception  If an exception occurs while starting.
     */
    void start() throws Exception;

    /**
     * Is the deployment started.
     * 
     * @return True if the deployment is started, otherwise false.
     */
    boolean isStarted();

    /**
     * Stop a deployment.
     * 
     * @throws Exception  If an exeption occurs while stoping.
     */
    void stop() throws Exception;

    /**
     * Gets the jboss-esb.xml configuration.
     * 
     * @return String   The jboss-esb.xml files content.
     */
    String getJbossEsbXml();

    /**
     * Gets the jboss-esb.xml configuration as html.
     * 
     * @return String   The jboss-esb.xml files content as html.
     */
    String getJbossEsbXmlAsHtml();
    
	String getStateString();
	
	int getState();

    public static final String[] states = {
        "Stopped", "Stopping", "Starting", "Started", "Failed",
        "Destroying", "Destroyed", "Creating", "Created", 
        "Initializing", "Initialized", "Unregistered"
     };

     /** stop has completed */
     public static final int STOPPED  = 0;
     /** stop has been invoked */
     public static final int STOPPING = 1;
     /** start has been invoked */
     public static final int STARTING = 2;
     /** start has completed */
     public static final int STARTED  = 3;
     /** There has been an error during some operation */
     public static final int FAILED  = 4;
     /** destroy has been invoked */ 
     public static final int DESTROYING = 5;
     /** destroy has completed */
     public static final int DESTROYED = 6;
     /** create has been invoked */
     public static final int CREATING = 7;
     /** create has completed */
     public static final int CREATED = 8;
     /** initialize has been invoked */
     public static final int INITIALIZING = 9;
     /** initialize has completed */
     public static final int INITIALIZED = 10;
     /** not yet created */
     public static final int UNREGISTERED = 11;
}
