/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.http.configurators;

/* 
 * 
 *@ author: Faisal Azizullah 
 *@ company : Lewisville ISD 
 * 
 */
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.Configurator;

import java.util.Properties;

/**
 * HTTP NTLM Authentication Configurator. <p/> Properties:
 * <ul>
 * <li><b>username</b>: See {@link NTCredentials}. (Required)</li>
 * <li><b>password</b>: See {@link NTCredentials}. (Required)</li>
 * <li><b>authscope-host</b>: See {@link AuthScope}. (Required)</li>
 * <li><b>authscope-port</b>: See {@link AuthScope}. (Required)</li>
 * <li><b>authscope-domain</b>: See {@link AuthScope}. (Required)</li>
 * <li><b>authscope-realm</b>: See {@link AuthScope}. (Optional)</li>
 * </ul>
 * <p/> See <a
 * href="http://jakarta.apache.org/commons/httpclient/authentication.html">HttpClient
 * Authentication Guide</a>.
 */

public class AuthNTLM extends Configurator
{
    public void configure (HttpClient httpClient, Properties properties)
            throws ConfigurationException
    {
        String username = properties.getProperty("ntauth-username");
        String password = properties.getProperty("ntauth-password");
        String authScopeHost = properties.getProperty("ntauthscope-host");
        String authScopePort = properties.getProperty("ntauthscope-port");
        String authScopeRealm = properties.getProperty("ntauthscope-realm");
        String authScopeDomain = properties.getProperty("ntauthscope-domain");

        assertPropertySetAndNotBlank(username, "ntauth-username");
        assertPropertySetAndNotBlank(password, "ntauth-password");
        assertPropertySetAndNotBlank(authScopeHost, "ntauthscope-host");
        assertPropertyIsInteger(authScopePort, "ntauthscope-port");
        assertPropertySetAndNotBlank(authScopeDomain, "ntauthscope-domain");
        
        password = getPasswordFromFile(password);
        
        Credentials creds = new NTCredentials(username, password,
                authScopeHost, authScopeDomain);
        AuthScope authScope;

        if (authScopeRealm != null && !authScopeRealm.trim().equals(""))
        {
            authScope = new AuthScope(authScopeHost, Integer
                    .parseInt(authScopePort), authScopeRealm);
        }
        else
        {
            authScope = new AuthScope(authScopeHost, Integer
                    .parseInt(authScopePort));
        }

        httpClient.getState().setCredentials(authScope, creds);
    }

}