/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.transformation.xslt;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;

import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

/**
 * Factory for {@link Result}s.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public final class ResultFactory
{
    public enum ResultType { STRING, BYTES, DOM, SAX, SOURCERESULT }
    
    private static ResultFactory factory = new ResultFactory();
    
    private ResultFactory() {} 
    
    public static ResultFactory getInstance()
    {
        return factory;
    }
    
    public Result createResult(final ResultType type)
    {
        Result result = null;
        switch ( type )
        {
            case STRING:
                result = new StreamResult(new StringWriter());
                break;
            case BYTES:
                result = new StreamResult(new ByteArrayOutputStream());
                break;
            case DOM:
                result = new DOMResult();
                break;
            case SAX:
                result = new SAXResult();
                break;
            default:
                break;
        }
        return result;
    }
    
    public Object extractResult(final Result result, final ResultType type)
    {
        switch ( type )
        {
            case STRING:
                return ((StreamResult)result).getWriter().toString();
            case BYTES:
                OutputStream outputStream = ((StreamResult)result).getOutputStream();
                return ((ByteArrayOutputStream)outputStream).toByteArray();
            case DOM:
                return ((DOMResult)result).getNode();
            case SAX:
                return (SAXResult)result;
            case SOURCERESULT:
                return result;
            default:
                throw new IllegalArgumentException("Result type not supported: " + result);
        }
    }
}
