/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions.templates;

import java.text.SimpleDateFormat;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.message.format.serialized.MessageImpl;
import org.jboss.soa.esb.message.Message;


/**
 * Use this class to tune your XML configurations <p/>Once your config works
 * with this dummy class, you can switch to your own action class 
 * 
 * @author Esteban
 * 
 */
public class MockComposer
{
    private static Logger _logger = Logger.getLogger(MockComposer.class);

    public Message composeEmptyMessage(Object obj) 
    {
        _logger.info(getLogMessage("process was called with <<" + obj.toString() + ">>"));
        MessageImpl message = new MessageImpl();
        return message;
    } // ________________________________

    private SimpleDateFormat s_oTS = new SimpleDateFormat(
            "yyyy/MM/dd hh:mm:ss.SSS");

    private String getLogMessage(String text)
    {
    	return new StringBuilder()
    	.append(s_oTS.format(new java.util.Date(System.currentTimeMillis())))
    	.append(" ").append(text)
    	.toString()
    	;
    }

} // ____________________________________________________________________________
