/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.routing.http;

import java.io.IOException;
import java.net.URL;

import org.apache.commons.httpclient.HttpMethodBase;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.Configurable;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ClassUtil;

/**
 * Http method executor.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public interface HttpMethodFactory extends Configurable {

    public void setEndpoint(URL url);

    public HttpMethodBase getInstance(Message message) throws IOException;

    public HttpMethodBase getMethod(String message, String contentType, String charset) throws IOException;

    /**
     * Uitility factory class for reflective {@link HttpMethodFactory} construction.
     */
    public static class Factory {

        public static HttpMethodFactory getInstance(String method, ConfigTree config, URL endpointUrl) throws ConfigurationException {
            AssertArgument.isNotNullAndNotEmpty(method, "method");
            AssertArgument.isNotNull(endpointUrl, "endpointUrl");

            String className = HttpMethodFactory.class.getPackage().getName() + "." + method + HttpMethodFactory.class.getSimpleName();

            try {
                HttpMethodFactory factory = (HttpMethodFactory) ClassUtil.forName(className, HttpMethodFactory.class).newInstance();
                factory.setEndpoint(endpointUrl);
                factory.setConfiguration(config);
                return factory;
            } catch (ClassCastException e) {
                throw new ConfigurationException("Class '" + className + "' must implement '" + HttpMethodFactory.class.getName() + "'.");
            } catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class '" + className + "' not found on classpath.");
            } catch (IllegalAccessException e) {
                throw new ConfigurationException("Class '" + className + "' cannot be instantiated.", e);
            } catch (InstantiationException e) {
                throw new ConfigurationException("Class '" + className + "' cannot be instantiated.", e);
            }
        }

    }
}
