/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.monitoring;

import java.io.Serializable;

/**
 * Bean for storing pattern information.    This bean stores: 
 * 
 * pattern - the pattern that is being monitored
 * name - the name for this pattern
 * conditional - expression that is tested to determine whether the information should be stored
 * messageString - the Message in the form of an XML string
 * 
 * @author tcunning
 * @since Version 4.4
 */
public class MonitoringPatternBean implements Serializable {
	private String pattern;
	private String name;
	private String conditional;
	private String messageString;
	
	/**
	 * Constructor method.
	 * @param name name
	 * @param pattern pattern
	 * @param conditional conditional
	 */
	public MonitoringPatternBean(String name, String pattern, String conditional) {
		this.pattern = pattern;
		this.name = name;
		this.conditional = conditional;
	}
	
	public String getName() {
		return name;
	}
	
	public String getPattern() {
		return pattern;
	}
	
	public String getConditional() {
		return conditional;
	}
	
	public String getMessageString() {
		return messageString;
	}
	
	public void setMessageString(String f_messageString) {
		messageString = f_messageString;
	}
	
	public String toString() {
		return "Pattern [" + pattern + "] "
			+ "Name [" + name + "] "
			+ "Conditional [" + conditional + "]"
			+ "Message [" + messageString + "]";
	}
}