/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.util.ClassUtil;

/**
 * XStream configuration class that holds information about attribute
 * aliases. 
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class AttributeAliasConf
{
    private String attribute;
    private Class<?> definedIn;

    public AttributeAliasConf(final String attribute, final String definedIn)
    {
        AssertArgument.isNotNullAndNotEmpty(attribute, "attribute");
        AssertArgument.isNotNullAndNotEmpty(definedIn, "definedIn");
        this.attribute = attribute;
        this.definedIn = loadClass(definedIn);
    }

    public String getAttribute()
    {
        return attribute;
    }

    public Class<?> getDefinedIn()
    {
        return definedIn;
    }

    public String toString()
    {
        return "AttributeAliasConf [attribute=" + attribute + ", definedIn=" + definedIn + "]";
    }
    
    private Class<?> loadClass(final String className)
    {
        try
        {
            return ClassUtil.forName(className, getClass());
        } 
        catch (final ClassNotFoundException e)
        {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
    }
}
