/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions;

import java.io.Serializable;

import org.jboss.soa.esb.message.Message;

/**
 * Action Processor Interface Definition.
 * <p/>
 * An "Action Processor" performs a processing action on a message payload and returns the processing
 * result.
 * <p/>
 * Implementations are constructed based on the following public constructor order precedence:
 * <ol>
 *  <li><b>(String actionName, List&lt;{@link org.jboss.soa.esb.helpers.KeyValuePair}&gt; properties)</b></li>
 *  <li><b>default constructor</b>.</li>
 * </ol>
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 * @since Version 4.0
 * 
 * @deprecated This interface has been replaced by {@link ActionPipelineProcessor}
 */
public interface ActionProcessor {
    
	
    /**
     * Perform the processing action on the message
     * @param message The message to be processed.
     * @return Message - result of process
     * @throws ActionProcessingException Exception during payload processing.
     */
    public Message process(Message message) throws ActionProcessingException;

    /**
     * Get the "OK" notification message for this processor.
     * @param message The message Object.
     * @return The OK message.
     */
    public abstract Serializable getOkNotification(Message message);

    /**
     * Get the "Error" notification message for this processor.
     * @param message The message Object.
     * @return The Error message.
     */
    public abstract Serializable getErrorNotification(Message message);
}
