/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.webservice.addressing;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.JBossDeployerUtil;

/**
 * @author <a href="mailto:mageshbk@jboss.com">Magesh Kumar B</a>
 */
public abstract class MAPBuilderFactory
{
   private static final Logger LOGGER = Logger.getLogger(MAPBuilderFactory.class);
   private static MAPBuilderFactory factory;

   public static MAPBuilderFactory getInstance()
   {
      if (factory == null)
      {
         String className = null;
         ClassLoader loader = Thread.currentThread().getContextClassLoader();
         try
         {
            Class factoryClass = null;
            if (JBossDeployerUtil.getWSImpl().equals(JBossDeployerUtil.WSIMPL_NATIVE))
            {
               className = "org.jboss.internal.soa.esb.webservice.addressing.def.NativeMAPBuilderFactory";
               factoryClass = loader.loadClass(className);
            }
            else if (JBossDeployerUtil.getWSImpl().equals(JBossDeployerUtil.WSIMPL_CXF))
            {
               className = "org.jboss.internal.soa.esb.webservice.addressing.cxf.CXFMAPBuilderFactory";
               factoryClass = loader.loadClass(className);
            }
            else
            {
                throw new IllegalStateException("Unable to support " + JBossDeployerUtil.WSIMPL_UNKNOWN +" WS implementation, only JBossWS-CXF and JBossWS-Native are supported!");
            }
            factory = (MAPBuilderFactory)factoryClass.newInstance();
         }
         catch (Throwable t)
         {
            throw new IllegalStateException("Failed to load: " + className + " of " + JBossDeployerUtil.getWSImpl(), t);
         }
      }
      return factory;
   }
   
   public abstract MAPBuilder getBuilderInstance();
}
