/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.internal.soa.esb.webservice;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

import com.arjuna.common.util.propertyservice.PropertyManager;


/**
 * This is the base class for a RequestResponse SOAP message
 * @author kevin
 */
public class RequestResponseBaseWebService extends BaseWebService
{
    private static final long DEFAULT_TIMEOUT = 30000L ;
    private static final long TIMEOUT ;
    private static final Logger LOGGER = Logger.getLogger(RequestResponseBaseWebService.class) ;
    
    protected RequestResponseBaseWebService(final String deployment, final ServiceInvoker serviceInvoker, final String requestLocation, final String responseLocation, final String action)
        throws MessageDeliverException
    {
        super(deployment, serviceInvoker, requestLocation, responseLocation, action) ;
    }
    
    @Override
    protected Message deliverMessage(final Message request)
            throws Exception
    {
        return serviceInvoker.deliverSync(request, TIMEOUT);
    }
    
    static
    {
        final PropertyManager propertyManager = ModulePropertyManager.getPropertyManager(ModulePropertyManager.TRANSPORTS_MODULE) ;
        final String timeoutVal = propertyManager.getProperty(Environment.WS_TIMEOUT);
        long timeout = DEFAULT_TIMEOUT ;
        if (timeoutVal != null)
        {
            try
            {
                timeout = Long.parseLong(timeoutVal) ;
            }
            catch (final NumberFormatException nfe)
            {
                LOGGER.warn("Failed to parse specified timeout: " + timeoutVal, nfe) ;
            }
        }
        TIMEOUT = timeout ;
    }
}
