/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.util;

import java.util.List;
import java.util.ListIterator;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

/**
 * Implementation of XMLEventReader which replays a set of XMLEvents.
 */
public class ESBXMLEventStreamReader implements XMLEventReader
{
    private final ListIterator<XMLEvent> eventIter ;

    public ESBXMLEventStreamReader(final List<XMLEvent> events)
    {
        eventIter = events.listIterator() ;
    }

    public Object next()
    {
        return nextEvent() ;
    }

    public void remove()
    {
        throw new UnsupportedOperationException("No support for remove()") ;
    }

    public void close()
        throws XMLStreamException
    {
    }

    public String getElementText()
        throws XMLStreamException
    {
        XMLEvent event = nextEvent() ;
        if (!event.isStartElement())
        {
            throw new XMLStreamException("Expected start element, found event type " + event.getEventType()) ;
        }
        final StringBuffer sb = new StringBuffer() ;
        while(hasNext())
        {
            event = nextEvent() ;
            if (event.isStartElement())
            {
                throw new XMLStreamException("Unexpected nested start element") ;
            }
            else if (event.isCharacters())
            {
                sb.append(event.asCharacters().getData()) ;
            }
            else if (event.isEndElement())
            {
                return sb.toString() ;
            }
        } 
        throw new XMLStreamException("Unexpected end of Document");
    }

    public Object getProperty(final String property)
        throws IllegalArgumentException
    {
        return null;
    }

    public boolean hasNext()
    {
        return eventIter.hasNext() ;
    }

    public XMLEvent nextEvent()
    {
        return eventIter.next() ;
    }

    public XMLEvent nextTag()
        throws XMLStreamException
    {
        while(hasNext())
        {
            final XMLEvent event = nextEvent() ;
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace())
            {
                throw new XMLStreamException("Unexpected character content in stream") ;
            }
            if (event.isStartElement() || event.isEndElement())
            {
                return event ;
            }
        }
        throw new XMLStreamException("End of document") ;
    }

    public XMLEvent peek()
        throws XMLStreamException
    {
        final XMLEvent peak = eventIter.next();
        eventIter.previous() ;
        return peak ;
    }
}
