/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.events;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/**
 * Base cached event information for events.
 */
public class ESBStaxXMLEvent implements XMLEvent
{
    private final int eventType ;
    private final Location location ;
    private QName schemaType ;
    
    protected ESBStaxXMLEvent(final XMLEvent event)
    {
        this.eventType = event.getEventType() ;
        final Location location = event.getLocation() ;
        this.location = (location == null ? null : new ESBStaxLocation(location)) ;
        this.schemaType = event.getSchemaType() ;
    }

    public Characters asCharacters()
    {
        throw new ClassCastException("Cannot case to Characters") ;
    }

    public EndElement asEndElement()
    {
        throw new ClassCastException("Cannot case to EndElement") ;
    }

    public StartElement asStartElement()
    {
        throw new ClassCastException("Cannot case to StartElement") ;
    }

    public int getEventType()
    {
        return eventType ;
    }

    public Location getLocation()
    {
        return location ;
    }

    public QName getSchemaType()
    {
        return schemaType ;
    }

    public boolean isAttribute()
    {
        return false ;
    }

    public boolean isCharacters()
    {
        return false ;
    }

    public boolean isEndDocument()
    {
        return false ;
    }

    public boolean isEndElement()
    {
        return false ;
    }

    public boolean isEntityReference()
    {
        return false ;
    }

    public boolean isNamespace()
    {
        return false ;
    }

    public boolean isProcessingInstruction()
    {
        return false ;
    }

    public boolean isStartDocument()
    {
        return false ;
    }

    public boolean isStartElement()
    {
        return false ;
    }

    public void writeAsEncodedUnicode(final Writer writer)
        throws XMLStreamException
    {
    }

    public static List<XMLEvent> cloneStream(final XMLEventReader reader)
        throws XMLStreamException
    {
        if (reader.hasNext())
        {
            final List<XMLEvent> events = new ArrayList<XMLEvent>() ;
            do
            {
                events.add(cloneEvent(reader.nextEvent())) ;
            }
            while(reader.hasNext()) ;
            return events ;
        }
        else
        {
            return Collections.emptyList() ;
        }
    }

    public static XMLEvent cloneEvent(final XMLEvent event)
        throws XMLStreamException
    {
        switch(event.getEventType())
        {
        case XMLStreamConstants.CDATA:
        case XMLStreamConstants.CHARACTERS:
        case XMLStreamConstants.SPACE:
            return new ESBStaxCharacters(event.asCharacters()) ;

        case XMLStreamConstants.COMMENT:
            return new ESBStaxComment((Comment)event) ;

        case XMLStreamConstants.DTD:
            return new ESBStaxDTD((DTD)event) ;

        case XMLStreamConstants.END_DOCUMENT:
            return new ESBStaxEndDocument((EndDocument)event) ;

        case XMLStreamConstants.END_ELEMENT:
            return new ESBStaxEndElement(event.asEndElement()) ;

        case XMLStreamConstants.ENTITY_REFERENCE:
            return new ESBStaxEntityReference((EntityReference)event) ;

        case XMLStreamConstants.PROCESSING_INSTRUCTION:
            return new ESBStaxProcessingInstruction((ProcessingInstruction)event) ;

        case XMLStreamConstants.START_DOCUMENT:
            return new ESBStaxStartDocument((StartDocument)event) ;

        case XMLStreamConstants.START_ELEMENT:
            return new ESBStaxStartElement(event.asStartElement()) ;
        }

        throw new XMLStreamException("Unrecognised event type: " + event.getEventType()) ;
    }
}
