/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.stream.events.EntityDeclaration;

/**
 * Cached event information for EntityDeclaration.
 */
public class ESBStaxEntityDeclaration extends ESBStaxXMLEvent implements EntityDeclaration
{
    private final String baseURI ;
    private final String name ;
    private final String notationName ;
    private final String publicId ;
    private final String replacementText ;
    private final String systemId ;

    public ESBStaxEntityDeclaration(final EntityDeclaration entityDeclaration)
    {
        super(entityDeclaration) ;
        baseURI = entityDeclaration.getBaseURI() ;
        name = entityDeclaration.getName() ;
        notationName = entityDeclaration.getNotationName() ;
        publicId = entityDeclaration.getPublicId() ;
        replacementText = entityDeclaration.getReplacementText() ;
        systemId = entityDeclaration.getSystemId() ;
    }

    public String getBaseURI()
    {
        return baseURI ;
    }

    public String getName()
    {
        return name ;
    }

    public String getNotationName()
    {
        return notationName ;
    }

    public String getPublicId()
    {
        return publicId ;
    }

    public String getReplacementText()
    {
        return replacementText ;
    }

    public String getSystemId()
    {
        return systemId ;
    }

    static List<EntityDeclaration> getEntities(final List<EntityDeclaration> entities)
    {
        if (entities == null)
        {
            return null ;
        }
        else if (entities.size() > 0)
        {
            final List<EntityDeclaration> result = new ArrayList<EntityDeclaration>() ;
            for(EntityDeclaration entity: entities)
            {
                result.add(new ESBStaxEntityDeclaration(entity)) ;
            }
            return result ;
        }
        else
        {
            return Collections.emptyList() ;
        }
    }
}
