/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.registry.client;

import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

/**
 * ESB specific InVM transport interface implemented by the scoped service.
 * 
 * @author <a href='mailto:Kevin.Conner@jboss.com'>Kevin Conner</a>
 */
public interface ESBInVMTransport
{
    /**
     * Return an API service for the specified node name and endpoint URL.
     * @param managerName The manager name.
     * @param nodeName The node name.
     * @param endpointURL The endpoint URL
     * @return The API service implementation.
     * @throws TransportException For exceptions obtaining the service implementation.
     */
    public JUDDIApiPortType getJUDDIApiService(final String managerName, final String nodeName, final String endpointURL)
        throws TransportException ;

    /**
     * Return a Custody Transfer service for the specified node name and endpoint URL.
     * @param managerName The manager name.
     * @param nodeName The node name.
     * @param endpointURL The endpoint URL
     * @return The Custody Transfer service implementation.
     * @throws TransportException For exceptions obtaining the service implementation.
     */
    public UDDICustodyTransferPortType getUDDICustodyTransferService(final String managerName, final String nodeName, final String endpointURL)
        throws TransportException ;

    /**
     * Return an Inquiry service for the specified node name and endpoint URL.
     * @param managerName The manager name.
     * @param nodeName The node name.
     * @param endpointURL The endpoint URL
     * @return The Inquiry service implementation.
     * @throws TransportException For exceptions obtaining the service implementation.
     */
    public UDDIInquiryPortType getUDDIInquiryService(final String managerName, final String nodeName, final String endpointURL)
        throws TransportException ;

    /**
     * Return a Publish service for the specified node name and endpoint URL.
     * @param managerName The manager name.
     * @param nodeName The node name.
     * @param endpointURL The endpoint URL
     * @return The Publish service implementation.
     * @throws TransportException For exceptions obtaining the service implementation.
     */
    public UDDIPublicationPortType getUDDIPublishService(final String managerName, final String nodeName, final String endpointURL)
        throws TransportException ;

    /**
     * Return a Security service for the specified node name and endpoint URL.
     * @param managerName The manager name.
     * @param nodeName The node name.
     * @param endpointURL The endpoint URL
     * @return The Security service implementation.
     * @throws TransportException For exceptions obtaining the service implementation.
     */
    public UDDISecurityPortType getUDDISecurityService(final String managerName, final String nodeName, final String endpointURL)
        throws TransportException ;

    /**
     * Return a Subscription Listener service for the specified node name and endpoint URL.
     * @param managerName The manager name.
     * @param nodeName The node name.
     * @param endpointURL The endpoint URL
     * @return The Subscription Listener service implementation.
     * @throws TransportException For exceptions obtaining the service implementation.
     */
    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService(final String managerName, final String nodeName, final String endpointURL)
        throws TransportException ;

    /**
     * Return a Subscription service for the specified node name and endpoint URL.
     * @param managerName The manager name.
     * @param nodeName The node name.
     * @param endpointURL The endpoint URL
     * @return The Subscription  service implementation.
     * @throws TransportException For exceptions obtaining the service implementation.
     */
    public UDDISubscriptionPortType getUDDISubscriptionService(final String managerName, final String nodeName, final String endpointURL)
        throws TransportException ;
}
