package org.jboss.internal.soa.esb.publish;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.listeners.config.Action;

/**
 * Action contract Publisher.
 *
 * @author
 */
public interface ActionContractPublisher extends ContractPublisher {

    /**
     * Set the action configuration.
     *
     * @param actionConfig The action configuration instance.
     * @throws org.jboss.soa.esb.ConfigurationException Configuration exception.
     */
    public void setActionConfig(Action actionConfig) throws ConfigurationException;
    
    // JBESB-3034
    public static class ProxyFactory {
    	
    	private static final String MockContractPublisher = "org.jboss.soa.esb.listeners.config.MockContractPublisher";
    	
    	public static ActionContractPublisher createContextClassLoaderProxy(final ActionContractPublisher pub) {
    		// can't use "instanceof" since it's only on the test classpath and not on the "ant dist" classpath
    		if ( pub.getClass().getName().equals(MockContractPublisher) ) {
    			return pub;
    		}
    		final List<Class<?>> ifaces_list = new ArrayList<Class<?>>();
    		ifaces_list.add(ActionContractPublisher.class);
    		if (pub instanceof ServletContractPublisher) {
    			ifaces_list.add(ServletContractPublisher.class);
    		}
    		if (pub instanceof ContractProvider) {
    			ifaces_list.add(ContractProvider.class);
    		}
    		final Class<?>[] ifaces_array = ifaces_list.toArray(new Class<?>[ifaces_list.size()]);
        	InvocationHandler handler = new InvocationHandler() {
        		private final ClassLoader new_loader = Thread.currentThread().getContextClassLoader();
    			public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
    				final ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
    				Thread.currentThread().setContextClassLoader(new_loader);
    				try {
    					return method.invoke(pub, args);
    				} finally {
    					Thread.currentThread().setContextClassLoader(old_loader);
    				}
    			}
        	};
        	return (ActionContractPublisher)Proxy.newProxyInstance(pub.getClass().getClassLoader(), ifaces_array, handler);
    	}
    	
    }
    
}
