<?xml version="1.0" encoding="ISO-8859-1"?>
<web-app xmlns="http://java.sun.com/xml/ns/javaee"
         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:schemaLocation="http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd"
         version="2.5">

    <#list webModel.filters as filter>

    <!-- Filter '${filter.name}' configuration... -->
    <filter>
        <filter-name>${filter.name}</filter-name>
        <filter-class>${filter.runtimeClass}</filter-class>

        <#list filter.params as param>
        <init-param>
            <param-name>${param.key}</param-name>
            <param-value>${param.value}</param-value>
        </init-param>
        </#list>

    </filter>

    <filter-mapping>
        <filter-name>${filter.name}</filter-name>
        <servlet-name>${filter.targetServlet.name}</servlet-name>
    </filter-mapping>
    </#list>

    <#list webModel.servlets as servlet>

    <!-- Servlet '${servlet.name}' configuration... -->
    <servlet>
        <servlet-name>${servlet.name}</servlet-name>
        <servlet-class>${servlet.runtimeClass}</servlet-class>

        <#list servlet.params as param>
        <init-param>
            <param-name>${param.key}</param-name>
            <param-value>${param.value}</param-value>
        </init-param>
        </#list>
        
        <#if servlet.loadOnStartup??>
        <load-on-startup>${servlet.loadOnStartup}</load-on-startup>
        </#if>
    
    </servlet>

    <#list servlet.urlMappings as urlMapping>
    <servlet-mapping>
        <servlet-name>${servlet.name}</servlet-name>
        <url-pattern>${urlMapping}</url-pattern>
    </servlet-mapping>
    </#list>
    </#list>

    <!-- Security constraints... -->
    <#list webModel.servlets as servlet>

    <#if servlet.securityConstraints??>
    <security-constraint>
        <web-resource-collection>
            <web-resource-name>Constraints for servlet ${servlet.name}</web-resource-name>
            <#list servlet.urlMappings as urlMapping>
            <url-pattern>${urlMapping}</url-pattern>
            </#list>
            <#list servlet.securityConstraints.protectedMethods as method>
            <http-method>${method}</http-method>
            </#list>
        </web-resource-collection>
        <#if (servlet.securityConstraints.allowedRoles?size > 0)>
        <auth-constraint>
            <#list servlet.securityConstraints.allowedRoles as role>
            <role-name>${role}</role-name>
            </#list>
        </auth-constraint>
        </#if>
        <#if servlet.securityConstraints.transportGuarantee??>
        <user-data-constraint>
            <transport-guarantee>${servlet.securityConstraints.transportGuarantee}</transport-guarantee>
        </user-data-constraint>
        </#if>
    </security-constraint>
    </#if>

    </#list>

    <#if webModel.authMethod??>
    <login-config>
        <auth-method>${webModel.authMethod}</auth-method>
        <realm-name>Authentication Realm for ${webModel.esbName}</realm-name>
    </login-config>
    </#if>

    <#list webModel.securityRoles as role>
    <security-role>
        <role-name>${role}</role-name>
    </security-role>
    </#list>

</web-app>
