package org.jboss.internal.soa.esb.command;

import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * Command queue abstraction.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 * @since Version 4.0
 */
public interface CommandQueue {

	/**
	 * Open the command queue.
	 * @param config Command queue configuration.
	 * @throws CommandQueueException Queue exception.  Check for probable chained cause exceptions.
	 */
	public void open(ConfigTree config) throws CommandQueueException;
	
	/**
	 * Receive a message from the underlying queue implementation.
	 * <p/>
	 * Performs a blocking receive on the command queue, controled by the receive timeout.
	 * @param timeout The receive block timeout.  Zero to block indefinitely.
	 * @return The command message from the queue.
	 * @throws CommandQueueException Queue exception.  Check for probable chained cause exceptions.
	 */
	public String receiveCommand(long timeout) throws CommandQueueException;
	
	/**
	 * Close the command queue.
	 * @throws CommandQueueException Queue exception.  Check for probable chained cause exceptions.
	 */
	public void close() throws CommandQueueException;
}
