/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006
 */

package org.jboss.internal.soa.esb.assertion;

import java.util.Collection;
import java.util.Map;

/**
 * Argument assertion utilities.
 * <p/>
 * <b>Copied from <a href="http://www.milyn.org">milyn.org</a></b>.
 *  
 * @author tfennelly
 */
public abstract class AssertArgument {

    /**
     * Assert that the argument is not null.
     * @param arg Argument.
     * @param argName Argument name.
     * @throws IllegalArgumentException Argument is null.
     */
    public static Object isNotNull(Object arg, String argName) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException("null '" + argName
                    + "' arg in method call.");
        }
        return arg;
    }

	/**
	 * Assert that the argument is not empty.
	 * @param arg Argument.
	 * @param argName Argument name.
	 * @throws IllegalArgumentException Argument is not null, but is empty.
	 */
	public static String isNotEmpty(String arg, String argName) throws IllegalArgumentException {
		if (arg != null && arg.trim().equals("")) {
			throw new IllegalArgumentException("Not null, but empty '"
					+ argName + "' arg in method call.");
		}
        return arg;
    }

	/**
	 * Assert that the argument is neither null nor empty.
	 * @param arg Argument.
	 * @param argName Argument name.
	 * @throws IllegalArgumentException Argument is null or empty.
	 */
	public static String isNotNullAndNotEmpty(String arg, String argName) throws IllegalArgumentException {
		if (arg == null || arg.trim().equals("")) {
			throw new IllegalArgumentException("null or empty '" + argName
					+ "' arg in method call.");
		}
        return arg;
	}

    /**
     * Assert that the argument is neither null nor empty.
     * @param arg Argument.
     * @param argName Argument name.
     * @throws IllegalArgumentException Argument is null or empty.
     */
    public static Collection isNotNullAndNotEmpty(Collection arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException("null or empty '" + argName
                    + "' arg in method call.");
        }
        return arg;
    }

    /**
     * Assert that the argument is neither null nor empty.
     * @param arg Argument.
     * @param argName Argument name.
     * @throws IllegalArgumentException Argument is null or empty.
     */
    public static Object[] isNotNullAndNotEmpty(Object[] arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("null or empty '" + argName
                    + "' arg in method call.");
        }
        return arg;
    }

    /**
     * Assert that the argument is neither null nor empty.
     * @param arg Argument.
     * @param argName Argument name.
     * @throws IllegalArgumentException Argument is null or empty.
     */
    public static Map isNotNullAndNotEmpty(Map arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException("null or empty '" + argName
                    + "' arg in method call.");
        }
        return arg;
    }
}
