package org.jboss.soa.esb.services.xml;

import junit.framework.TestCase;
import org.jboss.logging.Logger;


public class XmlValidationTest extends TestCase  {

    /**
     * Our Logger
     */
    private Logger log = Logger.getLogger(XmlValidationTest.class);

    /**
     * Validate the Email EPR
     * @throws Exception
     */
    public void testBasicEmailEPR() throws Exception {
        log.info("Running Basic Email EPR Test");
        XmlValidation xmlValidator = new XmlValidation();
        boolean isValid = xmlValidator.validate("basic-email-epr-example.xml","email-epr.xsd");
        assertTrue("Expecting basic-email-epr-example.xml to be valid.", isValid);
    }

    /**
     * Validate the JMS EPR
     * @throws Exception
     */
    public void testBasicJMSEPR() throws Exception {
        log.info("Running Basic JMS EPR Test");
        XmlValidation xmlValidator = new XmlValidation();
        boolean isValid = xmlValidator.validate("basic-jms-epr-example.xml","jms-epr.xsd");
        assertTrue("Expecting basic-jms-epr-example.xml to be valid.", isValid);
    }

    /**
     * Validate the JDBC EPR
     * @throws Exception
     */
    public void testBasicJDBCEPR() throws Exception {
        log.info("Running Basic JDBC EPR Test");
        XmlValidation xmlValidator = new XmlValidation();
        boolean isValid = xmlValidator.validate("basic-jdbc-epr-example.xml","jdbc-epr.xsd");
        assertTrue("Expecting basic-jdbc-epr-example.xml to be valid.", isValid);
    }

    /**
     * Validate the FTP EPR
     * @throws Exception
     */
    public void testBasicFTPEPR() throws Exception {
        log.info("Running Basic FTP EPR Test");
        XmlValidation xmlValidator = new XmlValidation();
        boolean isValid = xmlValidator.validate("basic-ftp-epr-example.xml","ftp-epr.xsd");
        assertTrue("Expecting basic-ftp-epr-example.xml to be valid.", isValid);
    }


}
