#!/bin/sh

#	This unpublishing example will remove the files published when the
#	publish script is run.
#
#  The unpublish.sh script can be used to quickly remove a file/files from
#  the command line
#
#  To get a list of all possible arguments, just execute JsonRestClient 
#  without any arguments or --help

# resolve links - $0 may be a softlink
LOC="$0"

while [ -h "$LOC" ] ; do
  ls=`ls -ld "$LOC"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '.*/.*' > /dev/null; then
    LOC="$link"
  else
    LOC=`dirname "$LOC"`/"$link"
  fi
done

LOCDIR=`dirname "$LOC"`
PRGDIR=`cd "$LOCDIR"; pwd`
SERVER="--server http://localhost:8080/modeshape-rest"
REPO="--repo eds"
WSPACE=" --workspacename default"
USER="--username admin"
PWD="--pwd admin"

UNPUB="--unpublish"


FILE="--file ./files/Products.xmi"
WSPACEPATH="--workspacepath  files/teiid"

java -cp "${PRGDIR}/../../client/*" org.modeshape.web.jcr.rest.client.json.JsonRestClient $SERVER $REPO $WSPACE $WSPACEPATH $FILE $USER $PWD $UNPUB  $*

FILE="--file ./files/document.txt"
WSPACEPATH="--workspacepath  files/text"

java -cp "${PRGDIR}/../../client/*" org.modeshape.web.jcr.rest.client.json.JsonRestClient $SERVER $REPO $WSPACE $WSPACEPATH $FILE $USER $PWD $UNPUB $*



