#!/bin/sh

#  This publishing example will publish 2 files to ModeShape: 
#  a Teiid model file (Products.xmi) and a text file (document.txt).
#
#
#  The publish.sh script can be used to quickly publish a file/files from
#  the command line
#
#  To deploy a directory of files at one time, normally of the same type, 
#  use the --dir  <dir> argument, instead of --file
#
#  To get a list of all possible arguments, just execute JsonRestClient 
#  without any arguments or --help

# resolve links - $0 may be a softlink
LOC="$0"

while [ -h "$LOC" ] ; do
  ls=`ls -ld "$LOC"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '.*/.*' > /dev/null; then
    LOC="$link"
  else
    LOC=`dirname "$LOC"`/"$link"
  fi
done

LOCDIR=`dirname "$LOC"`
PRGDIR=`cd "$LOCDIR"; pwd`
SERVER="--server http://localhost:8080/modeshape-rest"
REPO="--repo eds"
WSPACE=" --workspacename default"
USER="--username admin"
PWD="--pwd admin"


FILE="--file ./files/Products.xmi"
WSPACEPATH="--workspacepath  files/teiid"

java -cp "${PRGDIR}/../../client/*" org.modeshape.web.jcr.rest.client.json.JsonRestClient $SERVER $REPO $WSPACE $WSPACEPATH $FILE $USER $PWD  $*

FILE="--file ./files/document.txt"
WSPACEPATH="--workspacepath  files/text"

java -cp "${PRGDIR}/../../client/*" org.modeshape.web.jcr.rest.client.json.JsonRestClient $SERVER $REPO $WSPACE $WSPACEPATH $FILE $USER $PWD $*



