<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="urn:jboss:bean-deployer:2.0"
  xmlns:NS="urn:jboss:bean-deployer:2.0"
  exclude-result-prefixes='NS'
>
    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

    <xsl:template match="NS:deployment/NS:bean[@name='WSCXFContextPropertiesDeploymentAspect']/NS:property[@name='contextProperties']/NS:map/NS:entry" >
        <xsl:copy>
            <xsl:for-each select="node()" >
                <xsl:choose>
                    <xsl:when test="local-name() = 'value'" >
                        <value>org.jboss.internal.soa.esb.soap.cxf.ESBCXFServletExt</value>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:copy-of select="current()" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="NS:bean[@name='WSCXFContextPropertiesDeploymentAspect']" >
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
        <bean name="WSESBExtensionDeploymentAspect" class="org.jboss.internal.soa.esb.soap.cxf.ExtensionDeploymentAspect">
          <property name="provides">Extensions</property>
        </bean>
        <bean name="WSESBLoadOnStartupDeploymentAspect" class="org.jboss.internal.soa.esb.soap.cxf.LoadOnStartupDeploymentAspect">
          <property name="requires">WebMetaData</property>
          <property name="provides">ESBWebMetaData</property>
          <property name="servletClassProperty">org.jboss.ws.webapp.ServletClass</property>
          <property name="loadOnStartup">999999</property>
        </bean>
    </xsl:template>

    <xsl:template match="NS:deployment/NS:bean[@name='WSCXFDeploymentAspectInstallerPreJSE']/NS:property[@name='aspects']/NS:set" >
        <xsl:copy>
            <xsl:for-each select="@*">
                <xsl:copy/>
            </xsl:for-each>
            <xsl:for-each select="node()" >
                <xsl:copy-of select="current()" />
            </xsl:for-each>
            <inject bean="WSESBExtensionDeploymentAspect"/>
            <inject bean="WSESBLoadOnStartupDeploymentAspect"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*|@*|node()" >
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
