<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

    <xsl:template match="/project" priority="3">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
            <xsl:element name="target">
                <xsl:attribute name="name">patch-riftsaw</xsl:attribute>
                <xsl:attribute name="if">riftsaw.available</xsl:attribute>
                <xsl:element name="property">
                    <xsl:attribute name="name">RIFTSAW.bpel.jaxws.client.initializer.impl</xsl:attribute>
                    <xsl:attribute name="value">org.jboss.soa.bpel.runtime.ws.CXFJAXWSInitializer</xsl:attribute>
                </xsl:element>
                <xsl:element name="property">
                    <xsl:attribute name="file">${jboss510.home}/server/${jboss510.config}/deploy/riftsaw.sar/bpel.properties</xsl:attribute>
                    <xsl:attribute name="prefix">RIFTSAW</xsl:attribute>
                </xsl:element>
                <xsl:element name="echoproperties">
                    <xsl:attribute name="destfile">${jboss510.home}/server/${jboss510.config}/deploy/riftsaw.sar/bpel.properties</xsl:attribute>
                    <xsl:element name="propertySet">
                        <xsl:element name="propertyref">
                            <xsl:attribute name="prefix">RIFTSAW</xsl:attribute>
                        </xsl:element>
                        <xsl:element name="globmapper">
                            <xsl:attribute name="from">RIFTSAW.*</xsl:attribute>
                            <xsl:attribute name="to">*</xsl:attribute>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
            <xsl:element name="target">
                <xsl:attribute name="name">unpatch-riftsaw</xsl:attribute>
                <xsl:attribute name="if">riftsaw.available</xsl:attribute>
                <xsl:element name="property">
                    <xsl:attribute name="file">${jboss.server.home}/deploy/riftsaw.sar/bpel.properties</xsl:attribute>
                    <xsl:attribute name="prefix">RIFTSAW</xsl:attribute>
                </xsl:element>
                <xsl:element name="echoproperties">
                    <xsl:attribute name="destfile">${jboss.server.home}/deploy/riftsaw.sar/bpel.properties</xsl:attribute>
                    <xsl:element name="propertySet">
                        <xsl:attribute name="negate">true</xsl:attribute>
                        <xsl:element name="propertyref">
                            <xsl:attribute name="name">RIFTSAW.bpel.jaxws.client.initializer.impl</xsl:attribute>
                        </xsl:element>
                        <xsl:element name="propertySet">
                            <xsl:attribute name="negate">true</xsl:attribute>
                            <xsl:element name="propertyref">
                                <xsl:attribute name="prefix">RIFTSAW</xsl:attribute>
                            </xsl:element>
                        </xsl:element>
                        <xsl:element name="globmapper">
                            <xsl:attribute name="from">RIFTSAW.*</xsl:attribute>
                            <xsl:attribute name="to">*</xsl:attribute>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
            </xsl:element>

            <xsl:element name="target">
                <xsl:attribute name="name">patch-esb</xsl:attribute>
                <xsl:attribute name="if">esb.available</xsl:attribute>
                <xsl:element name="copy">
                    <xsl:attribute name="todir">${jboss510.home}/server/${jboss510.config}/deploy/soap.esb</xsl:attribute>
                    <xsl:attribute name="flatten">true</xsl:attribute>
                    <xsl:element name="fileset">
                        <xsl:attribute name="dir">${thirdpartydir}</xsl:attribute>
                        <xsl:attribute name="includes">**/velocity.jar</xsl:attribute>
                    </xsl:element>
                </xsl:element>
            </xsl:element>
            <xsl:element name="target">
                <xsl:attribute name="name">unpatch-esb</xsl:attribute>
                <xsl:attribute name="if">esb.available</xsl:attribute>
                <xsl:element name="delete">
                    <xsl:attribute name="file">${jboss.server.home}/deploy/soap.esb/velocity.jar</xsl:attribute>
                </xsl:element>
            </xsl:element>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="target[@name='deploy-jbossws-cxf51']">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
            <xsl:element name="basename">
                <xsl:attribute name="property">jboss510.config</xsl:attribute>
                <xsl:attribute name="file">${installserver}</xsl:attribute>
            </xsl:element>
            <xsl:element name="available">
                <xsl:attribute name="property">riftsaw.available</xsl:attribute>
                <xsl:attribute name="file">${jboss510.home}/server/${jboss510.config}/deploy/riftsaw.sar/bpel.properties</xsl:attribute>
            </xsl:element>
            <xsl:element name="antcall">
                <xsl:attribute name="target">patch-riftsaw</xsl:attribute>
            </xsl:element>
            <xsl:element name="available">
                <xsl:attribute name="property">esb.available</xsl:attribute>
                <xsl:attribute name="file">${jboss510.home}/server/${jboss510.config}/deployers/esb.deployer</xsl:attribute>
            </xsl:element>
            <xsl:element name="antcall">
                <xsl:attribute name="target">patch-esb</xsl:attribute>
            </xsl:element>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="macrodef[@name='macro-undeploy-jbossws51']/sequential">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
            <xsl:element name="available">
                <xsl:attribute name="property">riftsaw.available</xsl:attribute>
                <xsl:attribute name="file">${jboss.server.home}/deploy/riftsaw.sar/bpel.properties</xsl:attribute>
            </xsl:element>
            <xsl:element name="antcall">
                <xsl:attribute name="target">unpatch-riftsaw</xsl:attribute>
            </xsl:element>
            <xsl:element name="available">
                <xsl:attribute name="property">esb.available</xsl:attribute>
                <xsl:attribute name="file">${jboss.server.home}/deployers/esb.deployer</xsl:attribute>
            </xsl:element>
            <xsl:element name="antcall">
                <xsl:attribute name="target">unpatch-esb</xsl:attribute>
            </xsl:element>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="comment()" priority="3"/>

    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
