/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XPathModifier;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static DocumentBuilder documentBuilder;
    private static final Logger log;

    public static Document parse(InputStream in) {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing InputStream; " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static Document parse(String fileName) throws IOException {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(fileName);
        }
        catch (SAXException e) {
            log.error((Object)("Error parsing fileName [" + fileName + "]; " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static String entitize(String xml) {
        return xml.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public static Document parse(InputSource inputSource) throws IOException {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    private static DocumentBuilder ensureDocumentBuilder() {
        if (documentBuilder == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                documentBuilder = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                log.error((Object)("Error creating DocumentBuilder; " + e.getMessage()));
            }
        }
        return documentBuilder;
    }

    public static void serializePretty(Document document) {
        try {
            XmlUtils.serializePretty(document, (Writer)new OutputStreamWriter(System.out));
        }
        catch (IOException e) {
            log.error((Object)("Failed to seraialize: " + e));
        }
    }

    public static void serializePretty(Document dom, Writer writer) throws IOException {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((Node)dom.getDocumentElement());
            XmlUtils.serializePretty(xmlObject, writer);
        }
        catch (XmlException e) {
            throw new IOException(e.toString());
        }
    }

    public static void serializePretty(XmlObject xmlObject, Writer writer) throws IOException {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(3);
        options.setSaveNoXmlDecl();
        options.setSaveAggressiveNamespaces();
        xmlObject.save(writer, options);
    }

    public static void serialize(Document dom, Writer writer) throws IOException {
        XmlUtils.serialize(dom.getDocumentElement(), writer);
    }

    public static void serialize(Element elm, Writer writer) throws IOException {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((Node)elm);
            xmlObject.save(writer);
        }
        catch (XmlException e) {
            throw new IOException(e.toString());
        }
    }

    public static void setElementText(Element elm, String text) {
        Node node = elm.getFirstChild();
        if (node == null) {
            if (text != null) {
                elm.appendChild(elm.getOwnerDocument().createTextNode(text));
            }
        } else if (node.getNodeType() == 3) {
            if (text == null) {
                node.getParentNode().removeChild(node);
            } else {
                node.setNodeValue(text);
            }
        } else if (text != null) {
            Text textNode = node.getOwnerDocument().createTextNode(text);
            elm.insertBefore(textNode, elm.getFirstChild());
        }
    }

    public static String getChildElementText(Element elm, String name) {
        Element child = XmlUtils.getFirstChildElement(elm, name);
        return child == null ? null : XmlUtils.getElementText(child);
    }

    public static Element getFirstChildElement(Element elm) {
        return XmlUtils.getFirstChildElement(elm, null);
    }

    public static Element getFirstChildElement(Element elm, String name) {
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node node = nl.item(c);
            if (node.getNodeType() != 1 || name != null && !node.getNodeName().equals(name)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getFirstChildElementNS(Element elm, String tns, String localName) {
        if (tns == null && localName == null) {
            return XmlUtils.getFirstChildElement(elm);
        }
        if (tns == null) {
            return XmlUtils.getFirstChildElement(elm, localName);
        }
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node node = nl.item(c);
            if (node.getNodeType() != 1) continue;
            if (localName == null && tns.equals(node.getNamespaceURI())) {
                return (Element)node;
            }
            if (localName == null || !tns.equals(node.getNamespaceURI()) || !localName.equals(node.getLocalName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getElementText(Element elm) {
        Node node = elm.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        return null;
    }

    public static String getFragmentText(DocumentFragment elm) {
        Node node = elm.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        return null;
    }

    public static String getChildElementText(Element elm, String name, String defaultValue) {
        String result = XmlUtils.getChildElementText(elm, name);
        return result == null ? defaultValue : result;
    }

    public static String getNodeValue(Node node) {
        if (node.getNodeType() == 1) {
            return XmlUtils.getElementText((Element)node);
        }
        if (node.getNodeType() == 11) {
            return XmlUtils.getFragmentText((DocumentFragment)node);
        }
        return node.getNodeValue();
    }

    public static Node createNodeFromPath(Element modelElement, String path) {
        Document document = modelElement.getOwnerDocument();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (st.hasMoreTokens()) {
                if (t.equals("..")) {
                    modelElement = (Element)modelElement.getParentNode();
                    continue;
                }
                Element elm = XmlUtils.getFirstChildElement(modelElement, t);
                if (elm == null) {
                    modelElement = (Element)modelElement.insertBefore(document.createElement(t), XmlUtils.getFirstChildElement(modelElement, t));
                    continue;
                }
                modelElement = elm;
                continue;
            }
            modelElement = (Element)modelElement.insertBefore(document.createElement(t), XmlUtils.getFirstChildElement(modelElement, t));
        }
        return modelElement;
    }

    public static Element addChildElement(Element element, String name, String text) {
        Document document = element.getOwnerDocument();
        Element result = (Element)element.appendChild(document.createElement(name));
        if (text != null) {
            result.appendChild(document.createTextNode(text));
        }
        return result;
    }

    public static void setChildElementText(Element element, String name, String text) {
        Element elm = XmlUtils.getFirstChildElement(element, name);
        if (elm == null) {
            elm = element.getOwnerDocument().createElement(name);
            element.appendChild(elm);
        }
        XmlUtils.setElementText(elm, text);
    }

    public static Document parseXml(String xmlString) throws IOException {
        return XmlUtils.parse(new InputSource(new StringReader(xmlString)));
    }

    public static void dumpParserErrors(XmlObject xmlObject) {
        ArrayList errors = new ArrayList();
        xmlObject.validate(new XmlOptions().setErrorListener(errors));
        Iterator i = errors.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public static String transferValues(String source, String dest) {
        try {
            Document sourceDom = XmlUtils.parseXml(source);
            Document destDom = XmlUtils.parseXml(dest);
            TreeWalker walker = ((DocumentTraversal)((Object)sourceDom)).createTreeWalker(sourceDom.getDocumentElement(), 1, null, true);
            Element elm = (Element)walker.nextNode();
            while (elm != null) {
                String path = XmlUtils.getElementPath(elm);
                Node nsNode = XmlUtils.getNSNode(elm);
                Element elm2 = (Element)XPathAPI.selectSingleNode(destDom.getDocumentElement(), path, nsNode);
                if (elm2 != null) {
                    NamedNodeMap attributes = elm.getAttributes();
                    for (int c = 0; c < attributes.getLength(); ++c) {
                        Attr attr = (Attr)attributes.item(c);
                        elm2.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    }
                    XmlUtils.setElementText(elm2, XmlUtils.getElementText(elm));
                }
                elm = (Element)walker.nextNode();
            }
            StringWriter writer = new StringWriter();
            XmlUtils.serialize(destDom, (Writer)writer);
            return writer.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dest;
    }

    private static Node getNSNode(Node elm) {
        Element result = elm.getOwnerDocument().createElement("nsnode");
        while (elm != null) {
            NamedNodeMap attributes = elm.getAttributes();
            if (attributes != null) {
                for (int c = 0; c < attributes.getLength(); ++c) {
                    Node attr = attributes.item(c);
                    if (!attr.getNodeName().startsWith("xmlns:") && !attr.getNodeName().equals("xmlns")) continue;
                    result.setAttribute(attr.getNodeName(), attr.getNodeValue());
                }
            }
            elm = elm.getParentNode();
        }
        return result;
    }

    public static String getElementPath(Element element) {
        Node elm = element;
        String result = elm.getNodeName() + "[" + XmlUtils.getElementIndex(elm) + "]";
        while (elm.getParentNode() != null && elm.getParentNode().getNodeType() != 9) {
            elm = elm.getParentNode();
            result = elm.getNodeName() + "[" + XmlUtils.getElementIndex(elm) + "]/" + result;
        }
        return "/" + result;
    }

    public static int getElementIndex(Node element) {
        int result = 1;
        for (Node elm = element.getPreviousSibling(); elm != null; elm = elm.getPreviousSibling()) {
            if (elm.getNodeType() != 1 || !elm.getNodeName().equals(element.getNodeName())) continue;
            ++result;
        }
        return result;
    }

    public static String declareXPathNamespaces(String xmlString) throws XmlException {
        return XmlUtils.declareXPathNamespaces(XmlObject.Factory.parse((String)xmlString));
    }

    public static synchronized String prettyPrintXml(String xml) {
        try {
            if (xml == null) {
                return null;
            }
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(XmlObject.Factory.parse((String)xml), (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to prettyPrint xml: " + e));
            return xml;
        }
    }

    public static synchronized String prettyPrintXml(XmlObject xml) {
        try {
            if (xml == null) {
                return null;
            }
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(xml, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to prettyPrint xml: " + e));
            return xml.xmlText();
        }
    }

    public static String declareXPathNamespaces(WsdlInterface iface) {
        StringBuffer buf = new StringBuffer();
        buf.append("declare namespace soap='");
        buf.append(iface.getSoapVersion().getEnvelopeNamespace());
        buf.append("';\n");
        try {
            Collection<String> namespaces = iface.getWsdlContext().getDefinedNamespaces();
            int c = 1;
            Iterator<String> i = namespaces.iterator();
            while (i.hasNext()) {
                buf.append("declare namespace ns");
                buf.append(c++);
                buf.append("='");
                buf.append(i.next());
                buf.append("';\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public static String createXPath(Node node) {
        return XmlUtils.createXPath(node, false, false, null);
    }

    public static String createXPath(Node node, boolean anonymous, boolean selectText, XPathModifier modifier) {
        String pc;
        int index;
        StringToStringMap nsMap = new StringToStringMap();
        int nsCnt = 1;
        ArrayList<String> pathComponents = new ArrayList<String>();
        String namespaceURI = node.getNamespaceURI();
        if (node.getNodeType() == 2) {
            if (namespaceURI.length() > 0) {
                String prefix = node.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefix = "ns" + nsCnt++;
                }
                nsMap.put(namespaceURI, prefix);
                pathComponents.add("@" + prefix + ":" + node.getLocalName());
            } else {
                pathComponents.add("@" + node.getLocalName());
            }
            node = ((Attr)node).getOwnerElement();
        }
        if (node.getNodeType() == 1) {
            index = anonymous ? 0 : XmlUtils.findNodeIndex(node);
            pc = null;
            namespaceURI = node.getNamespaceURI();
            if (namespaceURI.length() > 0) {
                String prefix = node.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefix = "ns" + nsCnt++;
                }
                nsMap.put(namespaceURI, prefix);
                pc = prefix + ":" + node.getLocalName();
            } else {
                pc = node.getLocalName();
            }
            String elementText = XmlUtils.getElementText((Element)node);
            if (selectText && pathComponents.isEmpty() && elementText != null && elementText.trim().length() > 0) {
                pathComponents.add("text()");
            }
        } else {
            return null;
        }
        pathComponents.add(pc + (index == 0 ? "" : "[" + index + "]"));
        namespaceURI = node.getNamespaceURI();
        for (node = node.getParentNode(); !(node == null || node.getNodeType() != 1 || node.getNodeName().equals("Body") || namespaceURI.equals(SoapVersion.Soap11.getEnvelopeNamespace()) || namespaceURI.equals(SoapVersion.Soap12.getEnvelopeNamespace())); node = node.getParentNode()) {
            index = anonymous ? 0 : XmlUtils.findNodeIndex(node);
            String ns = (String)nsMap.get(namespaceURI);
            String pc2 = null;
            if (ns == null && namespaceURI.length() > 0) {
                String prefix = node.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    prefix = "ns" + nsCnt++;
                }
                nsMap.put(namespaceURI, prefix);
                ns = (String)nsMap.get(namespaceURI);
                pc2 = prefix + ":" + node.getLocalName();
            } else {
                pc2 = ns != null ? ns + ":" + node.getLocalName() : node.getLocalName();
            }
            pathComponents.add(pc2 + (index == 0 ? "" : "[" + index + "]"));
            namespaceURI = node.getNamespaceURI();
        }
        StringBuffer xpath = new StringBuffer();
        for (String ns : nsMap.keySet()) {
            xpath.append("declare namespace " + (String)nsMap.get(ns) + "='" + ns + "';\n");
        }
        if (modifier != null) {
            modifier.beforeSelector(xpath);
        }
        xpath.append("/");
        for (int c = pathComponents.size() - 1; c >= 0; --c) {
            xpath.append("/").append((String)pathComponents.get(c));
        }
        if (modifier != null) {
            modifier.afterSelector(xpath);
        }
        return xpath.toString();
    }

    private static int findNodeIndex(Node node) {
        String nm = node.getLocalName();
        String ns = node.getNamespaceURI();
        Node parentNode = node.getParentNode();
        if (parentNode.getNodeType() != 1) {
            return 1;
        }
        NodeList nl = ((Element)parentNode).getElementsByTagNameNS(ns, nm);
        if (nl.getLength() == 1) {
            return 0;
        }
        for (int c = 0; c < nl.getLength(); ++c) {
            if (nl.item(c) != node) continue;
            return c + 1;
        }
        throw new RuntimeException("Child node not found in parent!?");
    }

    public static boolean setNodeValue(Node domNode, String string) {
        short nodeType = domNode.getNodeType();
        if (nodeType == 1) {
            XmlUtils.setElementText((Element)domNode, string);
            return true;
        }
        if (nodeType == 2 || nodeType == 3) {
            domNode.setNodeValue(string);
            return true;
        }
        return false;
    }

    public static String declareXPathNamespaces(XmlObject xmlObject) {
        HashMap<QName, String> map = new HashMap<QName, String>();
        XmlCursor cursor = xmlObject.newCursor();
        while (cursor.hasNextToken()) {
            if (!cursor.toNextToken().isNamespace()) continue;
            map.put(cursor.getName(), cursor.getTextValue());
        }
        Iterator i = map.keySet().iterator();
        int nsCnt = 0;
        StringBuffer buf = new StringBuffer();
        HashSet<String> prefixes = new HashSet<String>();
        HashSet<String> usedPrefixes = new HashSet<String>();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            String prefix = name.getLocalPart();
            if (prefix.length() == 0) {
                prefix = "ns" + Integer.toString(++nsCnt);
            } else if (prefix.equals("xsd") || prefix.equals("xsi")) continue;
            if (prefixes.contains(prefix)) {
                int c = 1;
                while (usedPrefixes.contains(prefix + c)) {
                    ++c;
                }
                prefix = prefix + Integer.toString(c);
            } else {
                prefixes.add(prefix);
            }
            buf.append("declare namespace ");
            buf.append(prefix);
            buf.append("='");
            buf.append((String)map.get(name));
            buf.append("';\n");
            usedPrefixes.add(prefix);
        }
        return buf.toString();
    }

    public static String setXPathContent(String emptyResponse, String string, String actor) {
        try {
            XmlObject[] path;
            XmlObject xmlObject = XmlObject.Factory.parse((String)emptyResponse);
            for (XmlObject xml : path = xmlObject.selectPath(string)) {
                XmlUtils.setNodeValue(xml.getDomNode(), actor);
            }
            return xmlObject.toString();
        }
        catch (XmlException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static QName getQName(Node node) {
        if (node.getNamespaceURI() == null) {
            return new QName(node.getNodeName());
        }
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static String removeXPathNamespaceDeclarations(String xpath) {
        int ix;
        while (xpath.startsWith("declare namespace") && (ix = xpath.indexOf(59)) != -1) {
            xpath = xpath.substring(ix + 1).trim();
        }
        return xpath;
    }

    public static String stripWhitespaces(String content) {
        try {
            XmlObject xml = XmlObject.Factory.parse((String)content, (XmlOptions)new XmlOptions().setLoadStripWhitespace());
            content = xml.xmlText();
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static NodeList getChildElements(Element elm) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            if (nl.item(c).getNodeType() != 1) continue;
            list.add((Element)nl.item(c));
        }
        return new ElementNodeList(list);
    }

    public static boolean seemsToBeXml(String requestContent) {
        try {
            return requestContent != null && XmlObject.Factory.parse((String)requestContent) != null;
        }
        catch (XmlException e) {
            return false;
        }
    }

    static {
        log = Logger.getLogger(XmlUtils.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementNodeList
    implements NodeList {
        private final List<Element> list;

        public ElementNodeList(List<Element> list) {
            this.list = list;
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public Node item(int index) {
            return this.list.get(index);
        }
    }
}

