/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.report;

import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.report.JUnitReport;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class JUnitReportCollector
implements TestRunListener {
    HashMap<String, JUnitReport> reports = new HashMap();
    HashMap<TestCase, StringBuffer> failures = new HashMap();

    public void saveReports(String path) throws Exception {
        for (String name : this.reports.keySet()) {
            JUnitReport report = this.reports.get(name);
            this.saveReport(report, path + File.separatorChar + "TEST-" + name + ".xml");
        }
    }

    private void saveReport(JUnitReport report, String filename) throws Exception {
        FileWriter fileWriter = new FileWriter(filename);
        fileWriter.write(report.toString());
        fileWriter.close();
    }

    public String getReport() {
        Set<String> keys = this.reports.keySet();
        if (keys.size() > 0) {
            String key = (String)keys.toArray()[0];
            return this.reports.get(key).toString();
        }
        return "No reports..:";
    }

    public void afterRun(TestRunner testRunner, TestRunContext runContext) {
        TestCase testCase = testRunner.getTestCase();
        JUnitReport report = this.reports.get(testCase.getTestSuite().getName());
        if (TestRunner.Status.INITIALIZED != testRunner.getStatus() && TestRunner.Status.RUNNING != testRunner.getStatus()) {
            if (TestRunner.Status.CANCELED == testRunner.getStatus()) {
                report.addTestCaseWithFailure(testCase.getName(), testRunner.getTimeTaken(), testRunner.getReason(), "");
            }
            if (TestRunner.Status.FAILED == testRunner.getStatus()) {
                String msg = "";
                if (this.failures.containsKey(testCase)) {
                    msg = this.failures.get(testCase).toString();
                }
                report.addTestCaseWithFailure(testCase.getName(), testRunner.getTimeTaken(), testRunner.getReason(), msg);
            }
            if (TestRunner.Status.FINISHED == testRunner.getStatus()) {
                report.addTestCase(testCase.getName(), testRunner.getTimeTaken());
            }
        }
    }

    public void afterStep(TestRunner testRunner, TestRunContext runContext, TestStepResult result) {
        TestStep currentStep = runContext.getCurrentStep();
        TestCase testCase = currentStep.getTestCase();
        if (currentStep instanceof WsdlTestRequestStep) {
            WsdlTestRequestStep requestStep = (WsdlTestRequestStep)currentStep;
            for (int c = 0; c < requestStep.getAssertionCount(); ++c) {
                WsdlMessageAssertion assertion = requestStep.getAssertionAt(c);
                if (assertion.getStatus() == Assertable.AssertionStatus.VALID) continue;
                StringBuffer buf = new StringBuffer();
                if (this.failures.containsKey(testCase)) {
                    buf = this.failures.get(testCase);
                } else {
                    this.failures.put(testCase, buf);
                }
                buf.append(assertion.getName() + " in [" + requestStep.getName() + "] failed;\n");
                buf.append(Arrays.toString(assertion.getErrors()) + "\n");
                buf.append("Request: " + requestStep.getTestRequest().getRequestContent() + "\n");
                buf.append("Response: " + requestStep.getTestRequest().getResponse().getContentAsString() + "\n");
            }
        }
    }

    public void beforeRun(TestRunner testRunner, TestRunContext runContext) {
        TestCase testCase = testRunner.getTestCase();
        TestSuite testSuite = testCase.getTestSuite();
        if (!this.reports.containsKey(testSuite.getName())) {
            JUnitReport report = new JUnitReport();
            report.setTestSuiteName(testSuite.getProject().getName() + "." + testSuite.getName());
            this.reports.put(testSuite.getName(), report);
        }
    }

    public void beforeStep(TestRunner testRunner, TestRunContext runContext) {
    }
}

