/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.monitor;

import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.LoadTestRunListenerAdapter;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.support.WorkspaceListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.monitor.TestMonitorListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TestMonitor {
    private Set<TestMonitorListener> listeners = new HashSet<TestMonitorListener>();
    private InternalWorkspaceListener workspaceListener = new InternalWorkspaceListener();
    private InternalProjectListener projectListener = new InternalProjectListener();
    private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    private InternalTestRunListener testRunListener = new InternalTestRunListener();
    private InternalLoadTestRunListener loadTestRunListener = new InternalLoadTestRunListener();
    private Set<TestRunner> runningTestCases = new HashSet<TestRunner>();
    private Set<LoadTestRunner> runningLoadTests = new HashSet<LoadTestRunner>();

    protected void notifyLoadTestStarted(LoadTestRunner runner) {
        this.runningLoadTests.add(runner);
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].loadTestStarted(runner);
        }
    }

    protected void notifyLoadTestFinished(LoadTestRunner runner) {
        this.runningLoadTests.remove(runner.getLoadTest().getTestCase());
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].loadTestFinished(runner);
        }
    }

    protected void notifyTestCaseStarted(TestRunner runner) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].testCaseStarted(runner);
        }
    }

    protected void notifyTestCaseFinished(TestRunner runner) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TestMonitorListener[] l = this.listeners.toArray(new TestMonitorListener[this.listeners.size()]);
        for (int c = 0; c < l.length; ++c) {
            l[c].testCaseFinished(runner);
        }
    }

    public boolean hasRunningLoadTest(TestCase testCase) {
        Iterator<LoadTestRunner> iterator = this.runningLoadTests.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getLoadTest().getTestCase() != testCase) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningTestCase(TestCase testCase) {
        Iterator<TestRunner> iterator = this.runningTestCases.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getTestCase() != testCase) continue;
            return true;
        }
        return false;
    }

    public void addTestMonitorListener(TestMonitorListener listener) {
        this.listeners.add(listener);
    }

    public void removeTestMonitorListener(TestMonitorListener listener) {
        this.listeners.remove(listener);
    }

    public LoadTestRunner[] getRunningLoadTest() {
        return this.runningLoadTests.toArray(new LoadTestRunner[this.runningLoadTests.size()]);
    }

    public boolean hasRunningTest(TestCase testCase) {
        return this.hasRunningLoadTest(testCase) || this.hasRunningTestCase(testCase);
    }

    public void init(Workspace workspace) {
        for (int c = 0; c < workspace.getProjectCount(); ++c) {
            Project project = workspace.getProjectAt(c);
            this.monitorProject(project);
        }
        workspace.addWorkspaceListener(this.workspaceListener);
    }

    public void monitorProject(Project project) {
        project.addProjectListener(this.projectListener);
        for (int i = 0; i < project.getTestSuiteCount(); ++i) {
            this.monitorTestSuite(project.getTestSuiteAt(i));
        }
    }

    private void monitorTestSuite(TestSuite testSuite) {
        testSuite.addTestSuiteListener(this.testSuiteListener);
        for (int j = 0; j < testSuite.getTestCaseCount(); ++j) {
            this.monitorTestCase(testSuite.getTestCaseAt(j));
        }
    }

    private void monitorTestCase(TestCase testCase) {
        testCase.addTestRunListener(this.testRunListener);
        for (int v = 0; v < testCase.getLoadTestCount(); ++v) {
            testCase.getLoadTestAt(v).addLoadTestRunListener(this.loadTestRunListener);
        }
    }

    private void monitorLoadTest(LoadTest loadTest) {
        loadTest.addLoadTestRunListener(this.loadTestRunListener);
    }

    public void unmonitorProject(Project project) {
        project.removeProjectListener(this.projectListener);
        for (int c = 0; c < project.getTestSuiteCount(); ++c) {
            TestSuite testSuite = project.getTestSuiteAt(c);
            this.unmonitorTestSuite(testSuite);
        }
    }

    private void unmonitorTestSuite(TestSuite testSuite) {
        testSuite.removeTestSuiteListener(this.testSuiteListener);
        for (int j = 0; j < testSuite.getTestCaseCount(); ++j) {
            TestCase testCase = testSuite.getTestCaseAt(j);
            this.unmonitorTestCase(testCase);
        }
    }

    private void unmonitorTestCase(TestCase testCase) {
        testCase.removeTestRunListener(this.testRunListener);
        for (int c = 0; c < testCase.getLoadTestCount(); ++c) {
            this.unmonitorLoadTest(testCase.getLoadTestAt(c));
        }
    }

    private void unmonitorLoadTest(LoadTest loadTest) {
        loadTest.removeLoadTestRunListener(this.loadTestRunListener);
    }

    private class InternalLoadTestRunListener
    extends LoadTestRunListenerAdapter {
        private InternalLoadTestRunListener() {
        }

        public void afterLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
            TestMonitor.this.runningLoadTests.remove(testRunner);
            TestMonitor.this.notifyLoadTestFinished(testRunner);
        }

        public void beforeLoadTest(LoadTestRunner testRunner, LoadTestRunContext context) {
            TestMonitor.this.runningLoadTests.add(testRunner);
            TestMonitor.this.notifyLoadTestStarted(testRunner);
        }
    }

    private class InternalTestRunListener
    extends TestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        public void afterRun(TestRunner testRunner, TestRunContext runContext) {
            TestMonitor.this.runningTestCases.remove(testRunner);
            TestMonitor.this.notifyTestCaseFinished(testRunner);
        }

        public void beforeRun(TestRunner testRunner, TestRunContext runContext) {
            TestMonitor.this.runningTestCases.add(testRunner);
            TestMonitor.this.notifyTestCaseStarted(testRunner);
        }
    }

    private class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testCaseAdded(TestCase testCase) {
            TestMonitor.this.monitorTestCase(testCase);
        }

        public void testCaseRemoved(TestCase testCase) {
            TestMonitor.this.unmonitorTestCase(testCase);
        }

        public void loadTestAdded(LoadTest loadTest) {
            TestMonitor.this.monitorLoadTest(loadTest);
        }

        public void loadTestRemoved(LoadTest loadTest) {
            TestMonitor.this.unmonitorLoadTest(loadTest);
        }
    }

    private class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        public void testSuiteRemoved(TestSuite testSuite) {
            TestMonitor.this.unmonitorTestSuite(testSuite);
        }

        public void testSuiteAdded(TestSuite testSuite) {
            TestMonitor.this.monitorTestSuite(testSuite);
        }
    }

    private class InternalWorkspaceListener
    extends WorkspaceListenerAdapter {
        private InternalWorkspaceListener() {
        }

        public void projectRemoved(Project project) {
            TestMonitor.this.unmonitorProject(project);
        }

        public void projectAdded(Project project) {
            TestMonitor.this.monitorProject(project);
        }
    }
}

